/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.ponder.scenes;

import com.pedrorok.hypertube.blocks.HyperAcceleratorBlock;
import com.pedrorok.hypertube.blocks.blockentities.ActionTubeBlockEntity;
import com.pedrorok.hypertube.core.smarttube.ITubeAttachment;
import com.pedrorok.hypertube.items.TubeAttachmentItem;
import com.pedrorok.hypertube.registry.ModItems;
import com.simibubi.create.AllItems;
import com.simibubi.create.foundation.ponder.CreateSceneBuilder;
import net.createmod.catnip.math.Pointing;
import net.createmod.ponder.api.PonderPalette;
import net.createmod.ponder.api.element.ElementLink;
import net.createmod.ponder.api.element.ParrotPose;
import net.createmod.ponder.api.scene.SceneBuilder;
import net.createmod.ponder.api.scene.SceneBuildingUtil;
import net.createmod.ponder.api.scene.Selection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RedstoneLampBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RedstoneSide;
import net.minecraft.world.phys.Vec3;

public class AttachmentScenes {
    public static void attachmentScene(SceneBuilder builder, SceneBuildingUtil util) {
        CreateSceneBuilder scene = new CreateSceneBuilder(builder);
        TubeAttachmentItem tubeScannerItem = (TubeAttachmentItem)((Object)ModItems.TUBE_SCANNER.get());
        TubeAttachmentItem redstoneDetectorItem = (TubeAttachmentItem)((Object)ModItems.REDSTONE_DETECTOR.get());
        scene.title("attachments", "Hypertube Attachments");
        scene.configureBasePlate(1, 0, 5);
        scene.scaleSceneView(1.2f);
        scene.setSceneOffsetY(0.0f);
        scene.world().showSection(util.select().layer(0), Direction.UP);
        BlockPos acceleratorPos = util.grid().at(3, 3, 2);
        BlockPos entrancePos = util.grid().at(3, 1, 2);
        BlockPos redstonePos = util.grid().at(3, 1, 1);
        BlockPos redstoneLampPos = util.grid().at(3, 1, 0);
        Selection tubeS = util.select().fromTo(0, 3, 2, 6, 3, 2);
        Selection entranceTubeS = util.select().fromTo(3, 1, 2, 6, 1, 2);
        Selection redstoneLampS = util.select().position(redstoneLampPos);
        Selection redstoneCircuitS = util.select().position(redstonePos);
        Selection sideCogS = util.select().position(3, 1, 3);
        scene.world().setKineticSpeed(tubeS, 0.0f);
        scene.world().showSection(entranceTubeS, Direction.DOWN);
        scene.idle(5);
        for (int x = 6; x >= 3; --x) {
            scene.idle(2);
            scene.world().showSection(util.select().position(x, 1, 4), Direction.DOWN);
        }
        scene.idle(2);
        scene.world().setKineticSpeed(tubeS, 64.0f);
        scene.world().showSection(sideCogS, Direction.EAST);
        scene.world().setKineticSpeed(entranceTubeS, 32.0f);
        scene.idle(20);
        scene.overlay().showControls(util.vector().of(4.2, 1.0, 2.5), Pointing.RIGHT, 40).rightClick().withItem(tubeScannerItem.getDefaultInstance());
        scene.idle(5);
        AttachmentScenes.changeAttachment(builder, entrancePos, Direction.NORTH, tubeScannerItem.getTubeAttachment());
        scene.idle(5);
        scene.overlay().showText(70).attachKeyFrame().pointAt(util.vector().of(3.5, 1.0, 2.5)).placeNearTarget().text("The Scanner Attachment allows you to detect entities traveling the Hypertube.");
        scene.idle(60);
        scene.world().modifyBlock(redstonePos, state -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)RedStoneWireBlock.NORTH, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.SOUTH, (Comparable)RedstoneSide.SIDE)).setValue((Property)RedStoneWireBlock.EAST, (Comparable)RedstoneSide.NONE)).setValue((Property)RedStoneWireBlock.WEST, (Comparable)RedstoneSide.NONE), false);
        scene.idle(5);
        scene.world().showSection(redstoneCircuitS, Direction.SOUTH);
        scene.idle(5);
        scene.world().showSection(redstoneLampS, Direction.SOUTH);
        scene.idle(30);
        AttachmentScenes.changeOpenCloseEntrance((SceneBuilder)scene, entrancePos, true);
        ElementLink birb = scene.special().createBirb(new Vec3(1.5, 1.0, 2.5), ParrotPose.DancePose::new);
        scene.idle(40);
        scene.special().moveParrot(birb, new Vec3(0.0, 0.1, 0.0), 5);
        scene.special().changeBirbPose(birb, ParrotPose.FlappyPose::new);
        scene.idle(3);
        scene.special().moveParrot(birb, new Vec3(5.5, 0.0, 0.0), 20);
        scene.idle(4);
        AttachmentScenes.powerEverything(util, scene, true, false);
        scene.idle(4);
        AttachmentScenes.changeOpenCloseEntrance((SceneBuilder)scene, entrancePos, false);
        scene.special().hideElement(birb, Direction.EAST);
        scene.idle(20);
        AttachmentScenes.powerEverything(util, scene, false, false);
        scene.idle(20);
        scene.world().hideSection(entranceTubeS, Direction.UP);
        scene.idle(20);
        scene.world().modifyBlock(acceleratorPos, blockState -> (BlockState)blockState.setValue((Property)HyperAcceleratorBlock.ACTIVE, (Comparable)Boolean.valueOf(true)), false);
        scene.world().setKineticSpeed(tubeS, 32.0f);
        AttachmentScenes.changeAttachment(builder, acceleratorPos, Direction.NORTH, tubeScannerItem.getTubeAttachment());
        ElementLink tubeElement = scene.world().showIndependentSection(tubeS, Direction.DOWN);
        scene.world().moveSection(tubeElement, new Vec3(0.0, -2.0, 0.0), 0);
        scene.idle(10);
        scene.overlay().showText(40).attachKeyFrame().colored(PonderPalette.OUTPUT).pointAt(util.vector().of(3.5, 1.0, 2.5)).placeNearTarget().text("You can place in accelerators too, in any side at the same time");
        scene.idle(40);
        ElementLink birb2 = scene.special().createBirb(new Vec3(0.0, 1.1, 2.5), ParrotPose.FlappyPose::new);
        scene.special().moveParrot(birb2, new Vec3(3.0, 0.0, 0.0), 30);
        scene.idle(20);
        AttachmentScenes.changeOpenCloseEntrance((SceneBuilder)scene, acceleratorPos, true);
        scene.idle(10);
        AttachmentScenes.powerEverything(util, scene, true, false);
        scene.special().moveParrot(birb2, new Vec3(10.0, 0.0, 0.0), 40);
        scene.idle(10);
        AttachmentScenes.changeOpenCloseEntrance((SceneBuilder)scene, acceleratorPos, false);
        scene.special().hideElement(birb2, Direction.EAST);
        scene.idle(20);
        AttachmentScenes.powerEverything(util, scene, false, false);
        scene.idle(20);
        scene.world().hideSection(redstoneLampS, Direction.UP);
        scene.idle(12);
        scene.world().setBlock(redstoneLampPos, (BlockState)Blocks.LEVER.defaultBlockState().setValue((Property)LeverBlock.FACE, (Comparable)AttachFace.FLOOR), false);
        scene.world().showSection(redstoneLampS, Direction.DOWN);
        scene.idle(12);
        scene.overlay().showControls(Vec3.atCenterOf((Vec3i)entrancePos).add(0.8, -0.5, 0.0), Pointing.RIGHT, 20).rightClick().withItem(AllItems.WRENCH.asStack());
        scene.idle(12);
        AttachmentScenes.removeAttachment((SceneBuilder)scene, acceleratorPos, Direction.NORTH);
        scene.idle(20);
        scene.overlay().showControls(Vec3.atCenterOf((Vec3i)entrancePos).add(0.8, -0.5, 0.0), Pointing.RIGHT, 60).rightClick().withItem(redstoneDetectorItem.getDefaultInstance());
        scene.idle(5);
        AttachmentScenes.changeAttachment(builder, acceleratorPos, Direction.NORTH, redstoneDetectorItem.getTubeAttachment());
        scene.overlay().showText(80).attachKeyFrame().pointAt(util.vector().of(3.5, 1.0, 2.5)).placeNearTarget().text("You can change the Accelerator/Entrance mode with a Redstone signal.");
        scene.idle(60);
        scene.overlay().showControls(Vec3.atCenterOf((Vec3i)redstoneLampPos).add(0.2, -0.1, 0.0), Pointing.RIGHT, 20).rightClick();
        scene.idle(5);
        scene.world().modifyBlock(redstoneLampPos, state -> (BlockState)state.setValue((Property)LeverBlock.POWERED, (Comparable)Boolean.valueOf(true)), false);
        scene.effects().indicateSuccess(redstoneLampPos);
        AttachmentScenes.powerEverything(util, scene, true, true);
        scene.world().modifyBlock(acceleratorPos, blockState -> (BlockState)blockState.setValue((Property)HyperAcceleratorBlock.ACCELERATE, (Comparable)Boolean.valueOf(false)), false);
        scene.idle(40);
        ElementLink birb3 = scene.special().createBirb(new Vec3(0.0, 1.1, 2.5), ParrotPose.FlappyPose::new);
        scene.special().moveParrot(birb3, new Vec3(3.0, 0.0, 0.0), 15);
        scene.idle(10);
        AttachmentScenes.changeOpenCloseEntrance((SceneBuilder)scene, acceleratorPos, true);
        scene.idle(5);
        scene.special().moveParrot(birb3, new Vec3(10.0, 0.0, 0.0), 80);
        scene.idle(30);
        AttachmentScenes.changeOpenCloseEntrance((SceneBuilder)scene, acceleratorPos, false);
        scene.idle(40);
        scene.special().hideElement(birb3, Direction.EAST);
    }

    private static void powerEverything(SceneBuildingUtil util, CreateSceneBuilder scene, boolean activate, boolean ignoreLamp) {
        int power;
        BlockPos redstoneLamp = util.grid().at(3, 1, 0);
        BlockPos acceleratorPos = util.grid().at(3, 3, 2);
        BlockPos entrancePos = util.grid().at(3, 1, 2);
        BlockPos redstonePos = util.grid().at(3, 1, 1);
        int n = power = activate ? 15 : 0;
        if (!ignoreLamp) {
            scene.world().modifyBlock(redstoneLamp, state -> (BlockState)state.setValue((Property)RedstoneLampBlock.LIT, (Comparable)Boolean.valueOf(activate)), false);
        }
        AttachmentScenes.changeToPower(acceleratorPos, scene, power);
        AttachmentScenes.changeToPower(entrancePos, scene, power);
        AttachmentScenes.changeToPower(redstonePos, scene, power);
    }

    private static void changeToPower(BlockPos pos, CreateSceneBuilder scene, int power) {
        scene.world().modifyBlock(pos, state -> (BlockState)state.setValue((Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(power)), false);
    }

    private static void setSystemSpeed(SceneBuildingUtil util, CreateSceneBuilder scene, int entranceSpeed) {
        Selection mainShaftS = util.select().fromTo(3, 1, 5, 6, 1, 4);
        Selection sideCogS = util.select().position(3, 1, 3);
        Selection baseCog = util.select().position(6, 0, 3);
        Selection tubeS = util.select().position(3, 1, 2);
        scene.world().setKineticSpeed(baseCog, (float)(-entranceSpeed * 2));
        scene.world().setKineticSpeed(mainShaftS, (float)entranceSpeed);
        scene.world().setKineticSpeed(sideCogS, (float)(-entranceSpeed));
        scene.world().setKineticSpeed(tubeS, (float)entranceSpeed);
    }

    private static void removeAttachment(SceneBuilder builder, BlockPos p1, Direction direction) {
        builder.world().modifyBlockEntity(p1, ActionTubeBlockEntity.class, blockEntity -> {
            if (!blockEntity.hasTubeAttachment(direction)) {
                return;
            }
            blockEntity.removeTubeAttachment(direction);
        });
    }

    private static void changeAttachment(SceneBuilder builder, BlockPos p1, Direction direction, ITubeAttachment tubeAttachment) {
        builder.world().modifyBlockEntity(p1, ActionTubeBlockEntity.class, blockEntity -> blockEntity.addTubeAttachment(direction, tubeAttachment));
    }

    private static void changeOpenCloseEntrance(SceneBuilder builder, BlockPos p1, boolean open) {
        builder.world().modifyBlock(p1, blockState -> (BlockState)blockState.setValue((Property)HyperAcceleratorBlock.OPEN, (Comparable)Boolean.valueOf(open)), false);
    }
}

