/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.utils;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class CodecUtils {
    public static StreamCodec<ByteBuf, Vec3> VEC3 = new StreamCodec<ByteBuf, Vec3>(){

        @NotNull
        public Vec3 decode(ByteBuf buffer) {
            return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }

        public void encode(ByteBuf buffer, Vec3 value) {
            buffer.writeDouble(value.x);
            buffer.writeDouble(value.y);
            buffer.writeDouble(value.z);
        }
    };
    public static StreamCodec<ByteBuf, Integer> INTEGER = new StreamCodec<ByteBuf, Integer>(){

        @NotNull
        public Integer decode(ByteBuf byteBuf) {
            return byteBuf.readInt();
        }

        public void encode(ByteBuf byteBuf, Integer integer) {
            byteBuf.writeInt(integer.intValue());
        }
    };
    public static StreamCodec<ByteBuf, List<Vec3>> VEC3_LIST = new StreamCodec<ByteBuf, List<Vec3>>(){

        public List<Vec3> decode(ByteBuf byteBuf) {
            int size = byteBuf.readInt();
            ArrayList<Vec3> vec3s = new ArrayList<Vec3>(size);
            for (int i = 0; i < size; ++i) {
                vec3s.add((Vec3)VEC3.decode((Object)byteBuf));
            }
            return vec3s;
        }

        public void encode(ByteBuf o, List<Vec3> vec3s) {
            o.writeInt(vec3s.size());
            for (Vec3 vec3 : vec3s) {
                VEC3.encode((Object)o, (Object)vec3);
            }
        }
    };
}

