/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.chain_pulley;

import com.kipti.bnb.content.chain_pulley.ChainPulleyBlockEntity;
import com.kipti.bnb.registry.BnbBlocks;
import com.kipti.bnb.registry.BnbPartialModels;
import com.kipti.bnb.registry.BnbSpriteShifts;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.pulley.AbstractPulleyRenderer;
import com.simibubi.create.content.contraptions.pulley.PulleyBlock;
import com.simibubi.create.content.contraptions.pulley.PulleyContraption;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class ChainPulleyRenderer
extends AbstractPulleyRenderer<ChainPulleyBlockEntity> {
    private final PartialModel halfRope = BnbPartialModels.CHAIN_ROPE_HALF;
    private final PartialModel halfMagnet = BnbPartialModels.CHAIN_ROPE_HALF_MAGNET;

    public ChainPulleyRenderer(BlockEntityRendererProvider.Context context) {
        super(context, BnbPartialModels.CHAIN_ROPE_HALF, BnbPartialModels.CHAIN_ROPE_HALF_MAGNET);
    }

    protected void renderSafe(ChainPulleyBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState state = this.getRenderedBlockState((KineticBlockEntity)be);
        RenderType type = this.getRenderType((KineticBlockEntity)be, state);
        ChainPulleyRenderer.renderRotatingBuffer((KineticBlockEntity)be, (SuperByteBuffer)this.getRotatedModel((KineticBlockEntity)be, state), (PoseStack)ms, (VertexConsumer)buffer.getBuffer(type), (int)light);
        float offset = this.getOffset(be, partialTicks);
        boolean running = this.isRunning(be);
        VertexConsumer vb = buffer.getBuffer(RenderType.cutout());
        ChainPulleyRenderer.scrollCoil((SuperByteBuffer)this.getRotatedCoil((KineticBlockEntity)be), (SpriteShiftEntry)this.getCoilShift(), (float)offset, (float)1.0f).light(light).renderInto(ms, vb);
        Level world = be.getLevel();
        BlockState blockState = be.getBlockState();
        BlockPos pos = be.getBlockPos();
        SuperByteBuffer halfMagnetChain = CachedBuffers.partial((PartialModel)BnbPartialModels.CHAIN_PULLEY_MAGNET_CHAIN_HALF, (BlockState)blockState);
        SuperByteBuffer magnetChain = CachedBuffers.partial((PartialModel)BnbPartialModels.CHAIN_PULLEY_MAGNET_CHAIN, (BlockState)blockState);
        SuperByteBuffer halfRope = CachedBuffers.partial((PartialModel)this.halfRope, (BlockState)blockState);
        SuperByteBuffer magnetNoChains = this.renderMagnet(be);
        SuperByteBuffer rope = this.renderRope(be);
        if (running || offset == 0.0f) {
            ChainPulleyRenderer.renderAt((LevelAccessor)world, (SuperByteBuffer)magnetNoChains, (float)offset, (BlockPos)pos, (PoseStack)ms, (VertexConsumer)vb);
            ChainPulleyRenderer.renderAt((LevelAccessor)world, (SuperByteBuffer)ChainPulleyRenderer.scrollCoil((SuperByteBuffer)(offset > 0.25f ? magnetChain : halfMagnetChain), (SpriteShiftEntry)BnbSpriteShifts.CHAIN_ROPE, (float)offset, (float)1.0f), (float)offset, (BlockPos)pos, (PoseStack)ms, (VertexConsumer)vb);
        }
        float f = offset % 1.0f;
        if (offset > 0.75f && (f < 0.25f || f > 0.75f)) {
            ChainPulleyRenderer.renderAt((LevelAccessor)world, (SuperByteBuffer)ChainPulleyRenderer.scrollCoil((SuperByteBuffer)halfRope, (SpriteShiftEntry)BnbSpriteShifts.CHAIN_ROPE, (float)offset, (float)1.0f), (float)(f > 0.75f ? f - 1.0f : f), (BlockPos)pos, (PoseStack)ms, (VertexConsumer)vb);
        }
        if (!running) {
            return;
        }
        int i = 0;
        while ((float)i < offset - 1.25f) {
            ChainPulleyRenderer.renderAt((LevelAccessor)world, (SuperByteBuffer)ChainPulleyRenderer.scrollCoil((SuperByteBuffer)rope, (SpriteShiftEntry)BnbSpriteShifts.CHAIN_ROPE, (float)offset, (float)1.0f), (float)(offset - (float)i - 1.0f), (BlockPos)pos, (PoseStack)ms, (VertexConsumer)vb);
            ++i;
        }
    }

    protected Direction.Axis getShaftAxis(ChainPulleyBlockEntity be) {
        return (Direction.Axis)be.getBlockState().getValue(PulleyBlock.HORIZONTAL_AXIS);
    }

    protected PartialModel getCoil() {
        return BnbPartialModels.CHAIN_ROPE_COIL;
    }

    protected SuperByteBuffer renderRope(ChainPulleyBlockEntity be) {
        return CachedBuffers.block((BlockState)BnbBlocks.CHAIN_ROPE.getDefaultState());
    }

    protected SuperByteBuffer renderMagnet(ChainPulleyBlockEntity be) {
        return CachedBuffers.partial((PartialModel)BnbPartialModels.CHAIN_PULLEY_MAGNET_NO_CHAIN, (BlockState)be.getBlockState());
    }

    protected float getOffset(ChainPulleyBlockEntity be, float partialTicks) {
        return ChainPulleyRenderer.getBlockEntityOffset(partialTicks, be);
    }

    protected boolean isRunning(ChainPulleyBlockEntity be) {
        return ChainPulleyRenderer.isPulleyRunning(be);
    }

    public static boolean isPulleyRunning(ChainPulleyBlockEntity be) {
        return be.running || be.getMirrorParent() != null || be.isVirtual();
    }

    protected SpriteShiftEntry getCoilShift() {
        return BnbSpriteShifts.CHAIN_PULLEY_COIL;
    }

    public static float getBlockEntityOffset(float partialTicks, ChainPulleyBlockEntity blockEntity) {
        float offset = blockEntity.getInterpolatedOffset(partialTicks);
        AbstractContraptionEntity attachedContraption = blockEntity.getAttachedContraption();
        if (attachedContraption != null) {
            PulleyContraption c = (PulleyContraption)attachedContraption.getContraption();
            double entityPos = Mth.lerp((double)partialTicks, (double)attachedContraption.yOld, (double)attachedContraption.getY());
            offset = (float)(-(entityPos - (double)c.anchor.getY() - (double)c.getInitialOffset()));
        }
        return offset;
    }
}

