/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.block;

import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlock;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.PathedCogwheelNode;
import com.kipti.bnb.content.girder_strut.IBlockEntityRelighter;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.SimpleKineticBlockEntity;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class CogwheelChainBlockEntity
extends SimpleKineticBlockEntity
implements IBlockEntityRelighter,
SpecialBlockEntityItemRequirement,
TransformableBlockEntity {
    private boolean isController = false;
    @Nullable
    private CogwheelChain chain = null;
    @Nullable
    private Vec3i controllerOffset = null;
    private int chainsToRefund = 0;

    public CogwheelChainBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(5);
    }

    public void lazyTick() {
        BlockPos controllerPos;
        BlockEntity be;
        super.lazyTick();
        if (this.isController && this.chain != null) {
            if (!this.chain.checkIntegrity(this.level, this.worldPosition)) {
                this.destroyChain(true);
            }
        } else if (this.controllerOffset != null && this.level != null && !((be = this.level.getBlockEntity(controllerPos = this.worldPosition.offset(this.controllerOffset))) instanceof CogwheelChainBlockEntity)) {
            CogwheelChain.removeChainCogwheelFromLevelIfPresent(this.level, this.getBlockPos());
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.isController = compound.getBoolean("IsController");
        this.controllerOffset = compound.contains("ControllerOffsetX") ? new Vec3i(compound.getInt("ControllerOffsetX"), compound.getInt("ControllerOffsetY"), compound.getInt("ControllerOffsetZ")) : null;
        if (this.isController) {
            this.chainsToRefund = compound.getInt("ChainsToRefund");
            if (this.chain != null && compound.contains("Chain")) {
                this.chain.read(compound.getCompound("Chain"));
            } else {
                this.chain = new CogwheelChain(compound.getCompound("Chain"));
            }
        } else {
            this.chain = null;
        }
    }

    protected void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(compound, registries, clientPacket);
        this.writeConnectionInfo(compound);
    }

    public void writeSafe(CompoundTag tag, HolderLookup.Provider registries) {
        super.writeSafe(tag, registries);
        this.writeConnectionInfo(tag);
    }

    private void writeConnectionInfo(CompoundTag compound) {
        compound.putBoolean("IsController", this.isController);
        if (this.controllerOffset != null) {
            compound.putInt("ControllerOffsetX", this.controllerOffset.getX());
            compound.putInt("ControllerOffsetY", this.controllerOffset.getY());
            compound.putInt("ControllerOffsetZ", this.controllerOffset.getZ());
        }
        if (this.isController && this.chain != null) {
            CompoundTag chainTag = new CompoundTag();
            this.chain.write(chainTag);
            compound.put("Chain", (Tag)chainTag);
            compound.putInt("ChainsToRefund", this.chainsToRefund);
        }
    }

    public void destroy() {
        super.destroy();
        this.destroyChain(true);
    }

    public ItemStack destroyChain(boolean dropItemsInWorld) {
        BlockPos controllerPos;
        BlockEntity be;
        BlockPos controllerPos2;
        BlockEntity be2;
        int chainsToReturn = this.chainsToRefund;
        if (!this.isController && this.controllerOffset != null && this.level != null && (be2 = this.level.getBlockEntity(controllerPos2 = this.worldPosition.offset(this.controllerOffset))) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be2;
            chainsToReturn = controllerBE.chainsToRefund;
            controllerBE.chainsToRefund = 0;
        }
        ItemStack drops = Items.CHAIN.getDefaultInstance().copyWithCount(chainsToReturn);
        if (dropItemsInWorld) {
            Block.popResource((Level)this.level, (BlockPos)this.worldPosition, (ItemStack)drops);
        }
        this.chainsToRefund = 0;
        if (this.isController && this.chain != null) {
            this.chain.destroy(this.level, this.worldPosition);
        }
        if (!this.isController && this.controllerOffset != null && this.level != null && (be = this.level.getBlockEntity(controllerPos = this.worldPosition.offset(this.controllerOffset))) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be;
            assert (controllerBE.chain != null);
            controllerBE.chain.destroy(this.level, controllerPos);
        }
        return drops;
    }

    public void setController(Vec3i offset) {
        this.isController = false;
        this.controllerOffset = offset;
    }

    public void setAsController(CogwheelChain cogwheelChain) {
        this.isController = true;
        this.chain = cogwheelChain;
    }

    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().inflate(64.0);
    }

    public List<BlockPos> addPropagationLocations(IRotate block, BlockState state, List<BlockPos> neighbours) {
        BlockPos controllerPos;
        BlockEntity be;
        ArrayList<BlockPos> toPropagate = new ArrayList<BlockPos>(super.addPropagationLocations(block, state, neighbours));
        if (this.isController && this.chain != null) {
            this.addPropogationLocationsFromController(toPropagate, this.getBlockPos());
        } else if (this.controllerOffset != null && this.level != null && (be = this.level.getBlockEntity(controllerPos = this.worldPosition.offset(this.controllerOffset))) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be;
            controllerBE.addPropogationLocationsFromController(toPropagate, this.getBlockPos());
        }
        return toPropagate;
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (connectedViaAxes && Math.abs(diff.get((Direction.Axis)this.getBlockState().getValue((Property)CogwheelChainBlock.AXIS))) == 1) {
            return 0.0f;
        }
        if (target instanceof CogwheelChainBlockEntity) {
            boolean isControlledBySame;
            CogwheelChainBlockEntity chainTarget = (CogwheelChainBlockEntity)target;
            boolean bl = isControlledBySame = this.isController && chainTarget.controllerOffset != null && chainTarget.controllerOffset.equals((Object)this.getBlockPos().subtract((Vec3i)target.getBlockPos())) || chainTarget.isController && this.controllerOffset != null && this.controllerOffset.equals((Object)target.getBlockPos().subtract((Vec3i)this.getBlockPos())) || chainTarget.controllerOffset != null && this.controllerOffset != null && this.controllerOffset.offset((Vec3i)this.getBlockPos()).equals((Object)chainTarget.controllerOffset.offset((Vec3i)target.getBlockPos()));
            if (isControlledBySame) {
                float currentSide = this.getChainRotationFactor();
                float otherSide = chainTarget.getChainRotationFactor();
                return currentSide / otherSide;
            }
        }
        return 0.0f;
    }

    public float getChainRotationFactor() {
        if (this.isController) {
            if (this.chain == null) {
                return 0.0f;
            }
            PathedCogwheelNode controllerNode = this.chain.getNodeFromControllerOffset(new Vec3i(0, 0, 0));
            if (controllerNode == null) {
                return 0.0f;
            }
            return controllerNode.sideFactor();
        }
        if (this.level == null || this.controllerOffset == null) {
            return 0.0f;
        }
        BlockPos controllerPos = this.worldPosition.offset(this.controllerOffset);
        BlockEntity be = this.level.getBlockEntity(controllerPos);
        if (be instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be;
            CogwheelChain controllerChain = controllerBE.chain;
            if (controllerChain == null) {
                return 0.0f;
            }
            PathedCogwheelNode nodeInChain = controllerChain.getNodeFromControllerOffset(this.controllerOffset);
            return nodeInChain == null ? 0.0f : nodeInChain.sideFactor();
        }
        return 0.0f;
    }

    private void addPropogationLocationsFromController(List<BlockPos> toPropagate, BlockPos exclude) {
        if (this.chain == null) {
            return;
        }
        for (PathedCogwheelNode cogwheelNode : this.chain.getChainPathCogwheelNodes()) {
            BlockPos cogwheelPos = this.worldPosition.offset((Vec3i)cogwheelNode.localPos());
            if (toPropagate.contains(cogwheelPos) || cogwheelPos.equals((Object)exclude)) continue;
            toPropagate.add(cogwheelPos);
        }
    }

    public boolean isController() {
        return this.isController;
    }

    public void setController(boolean controller) {
        this.isController = controller;
    }

    @Nullable
    public CogwheelChain getChain() {
        return this.chain;
    }

    public void setChain(@Nullable CogwheelChain chain) {
        this.chain = chain;
    }

    @Nullable
    public Vec3i getControllerOffset() {
        return this.controllerOffset;
    }

    public void setControllerOffset(@Nullable Vec3i controllerOffset) {
        this.controllerOffset = controllerOffset;
    }

    public void setChainsUsed(int chainsUsed) {
        this.chainsToRefund = chainsUsed;
    }

    public void clearStoredChains() {
        BlockPos controllerPos;
        BlockEntity be;
        if (this.isController) {
            this.chainsToRefund = 0;
        } else if (this.controllerOffset != null && this.level != null && (be = this.level.getBlockEntity(controllerPos = this.worldPosition.offset(this.controllerOffset))) instanceof CogwheelChainBlockEntity) {
            CogwheelChainBlockEntity controllerBE = (CogwheelChainBlockEntity)be;
            controllerBE.chainsToRefund = 0;
        }
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        return this.isController ? new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, Blocks.CHAIN.asItem().getDefaultInstance().copyWithCount(this.chain != null ? this.chain.getChainsRequired() : 0)) : ItemRequirement.NONE;
    }

    public void transform(BlockEntity blockEntity, StructureTransform transform) {
        if (this.chain != null) {
            this.chain.transform(blockEntity, transform);
        }
        if (this.controllerOffset != null) {
            BlockPos transformedOffset = transform.applyWithoutOffset(new BlockPos(this.controllerOffset));
            this.setController((Vec3i)transformedOffset);
        }
    }
}

