/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.block;

import com.kipti.bnb.content.cogwheel_chain.block.CogwheelChainBlockEntity;
import com.kipti.bnb.content.cogwheel_chain.graph.CogwheelChain;
import com.kipti.bnb.content.cogwheel_chain.graph.RenderedChainPathNode;
import com.kipti.bnb.foundation.client.ShipyardHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.RenderTypes;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.function.Function;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import org.joml.Vector3f;

public class CogwheelChainBlockEntityRenderer
extends KineticBlockEntityRenderer<CogwheelChainBlockEntity> {
    public static final ResourceLocation CHAIN_LOCATION = ResourceLocation.withDefaultNamespace((String)"textures/block/chain.png");
    public static final int MIP_DISTANCE = 48;
    public static final int SEAM_DIST = 16;

    public CogwheelChainBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(CogwheelChainBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((KineticBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        Function lighter = be.createGlobalLighter();
        CogwheelChain chain = be.getChain();
        if (be.isController() && chain != null) {
            float rotationsPerTick = be.getChainRotationFactor() * be.getSpeed() / 1200.0f;
            float time = be.getLevel() != null ? AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel()) : AnimationTickHolder.getRenderTime();
            float offset = rotationsPerTick == 0.0f ? 0.0f : (float)(Math.PI * 2 * (double)rotationsPerTick * (double)time);
            double totalChainDistance = this.calculateTotalChainDistance(be);
            double chainTextureSquish = Math.ceil(totalChainDistance) / totalChainDistance;
            double accumulatedUV = 0.0;
            Vec3 origin = Vec3.atLowerCornerOf((Vec3i)be.getBlockPos());
            int size = chain.getChainPathNodes().size();
            for (int i = 0; i < size; ++i) {
                RenderedChainPathNode node0 = chain.getChainPathNodes().get((size + i - 1) % size);
                RenderedChainPathNode node1 = chain.getChainPathNodes().get(i);
                RenderedChainPathNode node2 = chain.getChainPathNodes().get((i + 1) % size);
                RenderedChainPathNode node3 = chain.getChainPathNodes().get((i + 2) % size);
                double stretchOffset = (double)offset + accumulatedUV;
                double distance = node1.getPosition().add(origin).distanceTo(node2.getPosition().add(origin));
                accumulatedUV += distance;
                this.renderChain(be, ms, buffer, node3.getPosition().add(origin), node2.getPosition().add(origin), node1.getPosition().add(origin), node0.getPosition().add(origin), lighter, (float)stretchOffset, (float)chainTextureSquish);
            }
        }
    }

    private double calculateTotalChainDistance(CogwheelChainBlockEntity be) {
        double totalDistance = 0.0;
        Vec3 origin = Vec3.atLowerCornerOf((Vec3i)be.getBlockPos());
        for (int i = 0; i < be.getChain().getChainPathNodes().size(); ++i) {
            RenderedChainPathNode nodeA = be.getChain().getChainPathNodes().get(i);
            RenderedChainPathNode nodeB = be.getChain().getChainPathNodes().get((i + 1) % be.getChain().getChainPathNodes().size());
            totalDistance += nodeA.getPosition().add(origin).distanceTo(nodeB.getPosition().add(origin));
        }
        return totalDistance;
    }

    private void renderChain(CogwheelChainBlockEntity be, PoseStack ms, MultiBufferSource buffer, Vec3 preFrom, Vec3 from, Vec3 to, Vec3 postTo, Function<Vector3f, Integer> lighter, float offset, float textureSquish) {
        boolean close;
        Vec3 diff = to.subtract(from);
        double yaw = 57.2957763671875 * Mth.atan2((double)diff.x, (double)diff.z);
        double pitch = 57.2957763671875 * Mth.atan2((double)diff.y, (double)diff.multiply(1.0, 0.0, 1.0).length());
        BlockPos tilePos = be.getBlockPos();
        Vec3 startOffset = from.subtract(Vec3.atCenterOf((Vec3i)tilePos));
        ms.pushPose();
        PoseTransformStack chain = TransformStack.of((PoseStack)ms);
        chain.center();
        chain.translate(startOffset);
        int light1 = lighter.apply(new Vector3f((float)from.x, (float)from.y, (float)from.z));
        int light2 = lighter.apply(new Vector3f((float)to.x, (float)to.y, (float)to.z));
        Vec3 cameraPosition = Minecraft.getInstance().getBlockEntityRenderDispatcher().camera.getPosition();
        boolean inShipyardLod = ShipyardHelper.isProbablyInShipyard(BlockPos.containing((Position)from));
        boolean far = !inShipyardLod && Minecraft.getInstance().level == be.getLevel() && !cameraPosition.closerThan((Position)from.lerp(to, 0.5), 48.0);
        boolean bl = close = !inShipyardLod && Minecraft.getInstance().level == be.getLevel() && cameraPosition.closerThan((Position)from.lerp(to, 0.5), 16.0);
        if (close) {
            CogwheelChainBlockEntityRenderer.renderChainSlowerButWithoutGaps(ms, buffer, offset, textureSquish, preFrom, from, to, postTo, light1, light2);
        } else {
            chain.rotateYDegrees((float)yaw);
            chain.rotateXDegrees(90.0f - (float)pitch);
            chain.rotateYDegrees(45.0f);
            float overextend = 0.05f;
            chain.translate(0.0f, 0.475f, 0.0f);
            chain.uncenter();
            CogwheelChainBlockEntityRenderer.renderChainFastButWithGaps(ms, buffer, offset - 0.025f, textureSquish, (float)from.distanceTo(to) + 0.05f, light1, light2, far);
        }
        ms.popPose();
    }

    private static void renderChainSlowerButWithoutGaps(PoseStack ms, MultiBufferSource buffer, float offset, float textureSquish, Vec3 preFrom, Vec3 from, Vec3 to, Vec3 postTo, int light1, int light2) {
        List<Vec3> endPoints = CogwheelChainBlockEntityRenderer.getEndPointsForChainJoint(from, to, postTo);
        List<Vec3> fromPoint = CogwheelChainBlockEntityRenderer.getEndPointsForChainJoint(preFrom, from, to);
        float length = (float)from.distanceTo(to);
        float minV = offset * textureSquish;
        float maxV = length * textureSquish + minV;
        float minU = 0.0f;
        float maxU = 0.1875f;
        ms.pushPose();
        VertexConsumer vc = buffer.getBuffer(RenderTypes.chain((ResourceLocation)CHAIN_LOCATION));
        Matrix4f matrix4f = ms.last().pose();
        for (int i = 0; i < 4; ++i) {
            float uO = i % 2 == 1 ? 0.0f : 0.1875f;
            CogwheelChainBlockEntityRenderer.addVertex(matrix4f, ms.last(), vc, endPoints.get((i + 2) % 4).subtract(from), 0.0f + uO, minV, light1);
            CogwheelChainBlockEntityRenderer.addVertex(matrix4f, ms.last(), vc, fromPoint.get((i + 2) % 4).subtract(from), 0.0f + uO, maxV, light1);
            CogwheelChainBlockEntityRenderer.addVertex(matrix4f, ms.last(), vc, fromPoint.get(i).subtract(from), 0.1875f + uO, maxV, light1);
            CogwheelChainBlockEntityRenderer.addVertex(matrix4f, ms.last(), vc, endPoints.get(i).subtract(from), 0.1875f + uO, minV, light1);
        }
        ms.popPose();
    }

    private static List<Vec3> getEndPointsForChainJoint(Vec3 before, Vec3 point, Vec3 after) {
        float radius = 0.09375f;
        Vec3 dirToBefore = point.subtract(before).normalize();
        Vec3 dirToAfter = after.subtract(point).normalize();
        Vec3 averagedDir = dirToBefore.add(dirToAfter).normalize();
        Quaternionf quat = new Quaternionf().rotationTo(0.0f, 1.0f, 0.0f, (float)averagedDir.x, (float)averagedDir.y, (float)averagedDir.z);
        Vector3d localAxis1Joml = quat.transform(1.0f, 0.0f, 0.0f, new Vector3d());
        Vec3 localAxis1 = new Vec3(localAxis1Joml.x, localAxis1Joml.y, localAxis1Joml.z).normalize();
        Vector3d localAxis2Joml = quat.transform(0.0f, 0.0f, 1.0f, new Vector3d());
        Vec3 localAxis2 = new Vec3(localAxis2Joml.x, localAxis2Joml.y, localAxis2Joml.z).normalize();
        return List.of(point.add(localAxis1.add(localAxis2).normalize().scale(0.09375)), point.add(localAxis1.subtract(localAxis2).normalize().scale(0.09375)), point.add(localAxis2.scale(-1.0).subtract(localAxis1).normalize().scale(0.09375)), point.add(localAxis2.subtract(localAxis1).normalize().scale(0.09375)));
    }

    private static void renderChainFastButWithGaps(PoseStack ms, MultiBufferSource buffer, float offset, float textureSquish, float length, int light1, int light2, boolean far) {
        float radius = far ? 0.0625f : 0.09375f;
        float minV = far ? 0.0f : offset * textureSquish;
        float maxV = far ? 0.0625f : length * textureSquish + minV;
        float minU = far ? 0.1875f : 0.0f;
        float maxU = far ? 0.25f : 0.1875f;
        ms.pushPose();
        ms.translate(0.5, 0.0, 0.5);
        VertexConsumer vc = buffer.getBuffer(RenderTypes.chain((ResourceLocation)CHAIN_LOCATION));
        CogwheelChainBlockEntityRenderer.renderPart(ms, vc, length, 0.0f, radius, radius, 0.0f, -radius, 0.0f, 0.0f, -radius, minU, maxU, minV, maxV, light1, light2, far);
        ms.popPose();
    }

    private static void renderPart(PoseStack pPoseStack, VertexConsumer pConsumer, float pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2, boolean far) {
        PoseStack.Pose posestack$pose = pPoseStack.last();
        Matrix4f matrix4f = posestack$pose.pose();
        float uO = far ? 0.0f : 0.1875f;
        CogwheelChainBlockEntityRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        CogwheelChainBlockEntityRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        CogwheelChainBlockEntityRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        CogwheelChainBlockEntityRenderer.renderQuad(matrix4f, posestack$pose, pConsumer, 0.0f, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(Matrix4f pPose, PoseStack.Pose pNormal, VertexConsumer pConsumer, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2) {
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(Matrix4f pPose, PoseStack.Pose pNormal, VertexConsumer pConsumer, Vec3 pPos, float pU, float pV, int light) {
        CogwheelChainBlockEntityRenderer.addVertex(pPose, pNormal, pConsumer, (float)pPos.y, (float)pPos.x, (float)pPos.z, pU, pV, light);
    }

    private static void addVertex(Matrix4f pPose, PoseStack.Pose pNormal, VertexConsumer pConsumer, float pY, float pX, float pZ, float pU, float pV, int light) {
        pConsumer.addVertex(pPose, pX, pY, pZ).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pNormal, 0.0f, 1.0f, 0.0f);
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRenderOffScreen(CogwheelChainBlockEntity blockEntity) {
        return true;
    }
}

