/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelNode;
import com.simibubi.create.content.contraptions.StructureTransform;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.phys.Vec3;

public record PathedCogwheelNode(int side, boolean isLarge, Direction.Axis rotationAxis, BlockPos localPos, boolean offsetForSmallCogwheel) {
    public PathedCogwheelNode(PlacingCogwheelNode partialNode, int side) {
        this(side, partialNode.isLarge(), partialNode.rotationAxis(), partialNode.pos(), partialNode.hasOffsetForSmallCogwheel());
    }

    public void write(CompoundTag nodeTag) {
        nodeTag.putBoolean("Side", this.side == 1);
        nodeTag.putBoolean("IsLarge", this.isLarge);
        nodeTag.putBoolean("OffsetForSmallCogwheel", this.offsetForSmallCogwheel);
        nodeTag.putInt("OffsetX", this.localPos.getX());
        nodeTag.putInt("OffsetY", this.localPos.getY());
        nodeTag.putInt("OffsetZ", this.localPos.getZ());
        nodeTag.putInt("RotationAxis", this.rotationAxis.ordinal());
    }

    public static PathedCogwheelNode read(CompoundTag nodeTag) {
        int side = nodeTag.getBoolean("Side") ? 1 : -1;
        boolean isLarge = nodeTag.getBoolean("IsLarge");
        BlockPos offset = new BlockPos(nodeTag.getInt("OffsetX"), nodeTag.getInt("OffsetY"), nodeTag.getInt("OffsetZ"));
        Direction.Axis rotationAxis = Direction.Axis.values()[nodeTag.getInt("RotationAxis")];
        boolean offsetForSmallCogwheel = nodeTag.contains("OffsetForSmallCogwheel") ? nodeTag.getBoolean("OffsetForSmallCogwheel") : !isLarge;
        return new PathedCogwheelNode(side, isLarge, rotationAxis, offset, offsetForSmallCogwheel);
    }

    public float sideFactor() {
        return (float)this.side * (this.isLarge ? 1.0f : 0.5f);
    }

    public Vec3 center() {
        return this.localPos.getCenter();
    }

    public Vec3 rotationAxisVec() {
        switch (this.rotationAxis) {
            case X: {
                return new Vec3(1.0, 0.0, 0.0);
            }
            case Y: {
                return new Vec3(0.0, 1.0, 0.0);
            }
            case Z: {
                return new Vec3(0.0, 0.0, 1.0);
            }
        }
        return Vec3.ZERO;
    }

    public double dist(PathedCogwheelNode other) {
        return this.center().distanceTo(other.center());
    }

    public PathedCogwheelNode transform(StructureTransform transform) {
        BlockPos transformedPos = transform.applyWithoutOffset(this.localPos);
        Direction transformedAxisResult = transform.rotateFacing(Direction.fromAxisAndDirection((Direction.Axis)this.rotationAxis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE));
        return new PathedCogwheelNode((transformedAxisResult.getAxisDirection() == Direction.AxisDirection.POSITIVE ? 1 : -1) * this.side, this.isLarge, transformedAxisResult.getAxis(), transformedPos, this.offsetForSmallCogwheel);
    }
}

