/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlock;
import com.kipti.bnb.content.girder_strut.GirderStrutBlockEntity;
import com.kipti.bnb.content.girder_strut.GirderStrutModelBuilder;
import com.kipti.bnb.content.girder_strut.GirderStrutModelManipulator;
import com.kipti.bnb.content.girder_strut.StrutModelType;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.List;
import java.util.function.Consumer;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperBufferFactory;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GirderStrutBlockEntityRenderer
extends SmartBlockEntityRenderer<GirderStrutBlockEntity> {
    public GirderStrutBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(GirderStrutBlockEntity blockEntity, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        Block block = blockEntity.getBlockState().getBlock();
        if (!(block instanceof GirderStrutBlock)) {
            return;
        }
        GirderStrutBlock girderStrutBlock = (GirderStrutBlock)block;
        StrutModelType modelType = girderStrutBlock.getModelType();
        if (Minecraft.getInstance().options.graphicsMode().get() == GraphicsStatus.FAST) {
            for (BlockPos pos : blockEntity.getConnectionsCopy()) {
                pos = pos.offset((Vec3i)blockEntity.getBlockPos());
                BlockState state = blockEntity.getLevel().getBlockState(pos);
                if (!(state.getBlock() instanceof GirderStrutBlock)) continue;
                BlockPos relative = pos.subtract((Vec3i)blockEntity.getBlockPos());
                Vec3 thisAttachment = Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).relative((Direction)blockEntity.getBlockState().getValue((Property)GirderStrutBlock.FACING), -0.4);
                BlockState otherState = blockEntity.getLevel().getBlockState(pos);
                Vec3 otherAttachment = Vec3.atCenterOf((Vec3i)pos).relative((Direction)otherState.getValue((Property)GirderStrutBlock.FACING), -0.4);
                double length = thisAttachment.distanceTo(otherAttachment);
                int segments = (int)Math.ceil(length);
                double lengthOffset = (length - (double)segments) / 2.0;
                ms.pushPose();
                Vec3 relativeVec = otherAttachment.subtract(thisAttachment);
                float distHorizontal = (float)Math.sqrt(relativeVec.x() * relativeVec.x() + relativeVec.z() * relativeVec.z());
                double yRot = distHorizontal == 0.0f ? 0.0 : Math.atan2(relativeVec.x(), relativeVec.z());
                double xRot = (float)Math.atan2(relativeVec.y(), distHorizontal);
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(Vec3.atLowerCornerOf((Vec3i)((Direction)blockEntity.getBlockState().getValue((Property)GirderStrutBlock.FACING)).getNormal()).scale(-0.4))).center()).rotateY((float)yRot)).rotateX(-((float)xRot))).uncenter();
                ms.translate(0.0, 0.0, lengthOffset + 0.5);
                if (this.getRenderPriority((Vec3i)relative) > this.getRenderPriority(relative.multiply(-1))) {
                    this.renderSegments(state, modelType.getPartialModel(), ms, segments, buffer, blockEntity.getLevel() == null ? light : LevelRenderer.getLightColor((BlockAndTintGetter)blockEntity.getLevel(), (BlockPos)pos));
                }
                ms.popPose();
            }
        } else {
            if (blockEntity.connectionRenderBufferCache == null) {
                try (ByteBufferBuilder bufferBuilder = new ByteBufferBuilder(256);){
                    GirderStrutModelBuilder.GirderStrutModelData connectionData = GirderStrutModelBuilder.GirderStrutModelData.collect((BlockAndTintGetter)blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity);
                    List quads = connectionData.connections().stream().flatMap(c -> GirderStrutModelManipulator.bakeConnectionToConsumer(c, modelType, blockEntity.createLighter()).stream()).toList();
                    BufferBuilder builder = new BufferBuilder(bufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                    for (Consumer quad : quads) {
                        quad.accept(builder);
                    }
                    MeshData meshData = builder.build();
                    if (meshData == null) {
                        return;
                    }
                    blockEntity.connectionRenderBufferCache = SuperBufferFactory.getInstance().create(meshData);
                }
            }
            blockEntity.connectionRenderBufferCache.renderInto(ms, buffer.getBuffer(RenderType.solid()));
        }
    }

    protected void renderSegments(BlockState state, PartialModel model, PoseStack ms, int length, MultiBufferSource buffer, int light) {
        for (int i = 0; i < length; ++i) {
            ms.pushPose();
            ms.translate(0.0f, 0.0f, (float)i);
            CachedBuffers.partial((PartialModel)model, (BlockState)state).light(light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
            ms.popPose();
        }
    }

    protected int getRenderPriority(Vec3i relative) {
        return relative.getY() * 10000 + relative.getX() * 100 + relative.getZ();
    }

    @NotNull
    public AABB getRenderBoundingBox(@NotNull GirderStrutBlockEntity blockEntity) {
        return super.getRenderBoundingBox((BlockEntity)blockEntity).inflate(10.0);
    }

    public boolean shouldRender(GirderStrutBlockEntity blockEntity, Vec3 cameraPos) {
        return true;
    }

    public boolean shouldRenderOffScreen(GirderStrutBlockEntity blockEntity) {
        return true;
    }
}

