/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlock;
import com.kipti.bnb.content.girder_strut.GirderStrutBlockItem;
import com.kipti.bnb.registry.BnbDataComponents;
import net.createmod.catnip.outliner.Outliner;
import net.createmod.catnip.theme.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class GirderStrutPlacementEffects {
    private static final float PARTICLE_DENSITY = 0.1f;

    public static void tick(LocalPlayer player) {
        ItemStack heldItem;
        if (Minecraft.getInstance().isPaused() || Minecraft.getInstance().hitResult == null) {
            return;
        }
        Object object = player.getMainHandItem().getItem() instanceof GirderStrutBlockItem ? player.getMainHandItem() : (heldItem = player.getOffhandItem().getItem() instanceof GirderStrutBlockItem ? player.getOffhandItem() : null);
        if (heldItem != null) {
            GirderStrutPlacementEffects.display(player, heldItem);
        }
    }

    private static void display(LocalPlayer player, ItemStack heldItem) {
        BlockHitResult hit;
        Direction fromFace;
        BlockPos fromPos;
        ClientLevel level;
        block10: {
            block9: {
                level = Minecraft.getInstance().level;
                if (level == null) {
                    return;
                }
                fromPos = (BlockPos)heldItem.get(BnbDataComponents.GIRDER_STRUT_FROM);
                fromFace = (Direction)heldItem.get(BnbDataComponents.GIRDER_STRUT_FROM_FACE);
                if (fromPos == null) {
                    return;
                }
                HitResult genericHit = Minecraft.getInstance().hitResult;
                if (!(genericHit instanceof BlockHitResult)) break block9;
                hit = (BlockHitResult)genericHit;
                if (genericHit.getType() == HitResult.Type.BLOCK) break block10;
            }
            return;
        }
        BlockPos targetPos = GirderStrutPlacementEffects.resolvePlacementPos(level, hit.getBlockPos(), hit.getDirection());
        if (targetPos == null || targetPos.distSqr((Vec3i)fromPos) > 96.0) {
            return;
        }
        Direction targetFace = hit.getDirection();
        BlockState targetState = level.getBlockState(targetPos);
        if (targetState.getBlock() instanceof GirderStrutBlock) {
            targetFace = (Direction)targetState.getValue((Property)GirderStrutBlock.FACING);
        }
        Vec3 renderFrom = Vec3.atCenterOf((Vec3i)fromPos);
        Vec3 renderTo = Vec3.atCenterOf((Vec3i)targetPos);
        Vec3 delta = renderTo.subtract(renderFrom);
        double length = delta.length();
        if (length < 0.001 || length > 24.0) {
            return;
        }
        boolean valid = GirderStrutBlockItem.isValidConnection((Level)level, fromPos, fromFace, targetPos, targetFace);
        Vec3 dir = delta.normalize();
        double step = 0.25;
        Vector3f color = valid ? new Vector3f(0.3f, 0.9f, 0.5f) : new Vector3f(0.9f, 0.3f, 0.5f);
        Vector3f outlinerColor = valid ? new Vector3f(0.35f, 0.85f, 0.55f) : new Vector3f(0.85f, 0.35f, 0.55f);
        for (double t = 0.0; t <= length; t += 0.25) {
            Vec3 lerped = renderFrom.add(dir.scale(t));
            if (level.getRandom().nextFloat() > 0.1f) continue;
            level.addParticle((ParticleOptions)new DustParticleOptions(color, 1.0f), true, lerped.x, lerped.y, lerped.z, 0.0, 0.0, 0.0);
        }
        level.addParticle((ParticleOptions)new DustParticleOptions(color, 1.0f), true, renderTo.x, renderTo.y, renderTo.z, 0.0, 0.0, 0.0);
        GirderStrutPlacementEffects.showAnchorBox(fromPos, fromFace.getOpposite(), "from", (int)(outlinerColor.x * 256.0f), (int)(outlinerColor.y * 256.0f), (int)(outlinerColor.z * 256.0f));
        GirderStrutPlacementEffects.showAnchorBox(targetPos, targetFace.getOpposite(), "to", (int)(outlinerColor.x * 256.0f), (int)(outlinerColor.y * 256.0f), (int)(outlinerColor.z * 256.0f));
    }

    private static void showAnchorBox(BlockPos targetPos, Direction targetFace, String id, int r, int g, int b) {
        AABB box = new AABB(0.0, 0.0, 0.0, (double)((targetFace.getStepX() == 0 ? 0.25f : 0.0f) + 0.25f), (double)((targetFace.getStepY() == 0 ? 0.25f : 0.0f) + 0.25f), (double)((targetFace.getStepZ() == 0 ? 0.25f : 0.0f) + 0.25f));
        box = box.move((double)targetPos.getX(), (double)targetPos.getY(), (double)targetPos.getZ()).move(-box.getXsize() * 0.5 + 0.5, -box.getYsize() * 0.5 + 0.5, -box.getZsize() * 0.5 + 0.5).move((double)((float)targetFace.getStepX() * 0.5f), (double)((float)targetFace.getStepY() * 0.5f), (double)((float)targetFace.getStepZ() * 0.5f));
        Outliner.getInstance().showAABB((Object)id, box).colored(new Color(r, g, b)).lineWidth(0.0625f);
    }

    private static BlockPos resolvePlacementPos(ClientLevel level, BlockPos clickedPos, Direction face) {
        BlockPos pos = clickedPos;
        if (!(level.getBlockState(pos).getBlock() instanceof GirderStrutBlock || level.getBlockState(pos = pos.relative(face)).canBeReplaced() || level.getBlockState(pos).getBlock() instanceof GirderStrutBlock)) {
            return null;
        }
        return pos;
    }
}

