/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut.mesh;

import com.kipti.bnb.content.girder_strut.mesh.GirderMeshQuad;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.util.Mth;

public final class GirderSegmentMesh {
    private final List<GirderMeshQuad> baseQuads;

    public GirderSegmentMesh(List<BakedQuad> quads) {
        this.baseQuads = quads.stream().map(GirderMeshQuad::from).filter(Objects::nonNull).toList();
    }

    public List<GirderMeshQuad> forLength(float length) {
        int fullSegments = Mth.floor((float)(length + 1.0E-4f));
        float partial = length - (float)fullSegments;
        ArrayList<GirderMeshQuad> result = new ArrayList<GirderMeshQuad>(this.baseQuads.size() * (fullSegments + 1));
        for (int i = 0; i < fullSegments; ++i) {
            float offset = i;
            for (GirderMeshQuad quad : this.baseQuads) {
                result.add(quad.translate(0.0f, 0.0f, offset));
            }
        }
        if (partial > 1.0E-4f) {
            for (GirderMeshQuad quad : this.baseQuads) {
                GirderMeshQuad clipped = quad.clipZ(partial);
                if (clipped == null) continue;
                result.add(clipped.translate(0.0f, 0.0f, fullSegments));
            }
        }
        if (result.isEmpty()) {
            for (GirderMeshQuad quad : this.baseQuads) {
                GirderMeshQuad fallback = quad.clipZ(Math.max(partial, 1.0E-4f));
                if (fallback == null) continue;
                result.add(fallback);
            }
        }
        return result;
    }
}

