/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.light.headlamp;

import com.kipti.bnb.content.light.headlamp.HeadlampBlock;
import com.kipti.bnb.registry.BnbBlocks;
import com.kipti.bnb.registry.BnbShapes;
import com.simibubi.create.AllShapes;
import com.simibubi.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.simibubi.create.content.schematics.requirement.ItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class HeadlampBlockEntity
extends SmartBlockEntity
implements SpecialBlockEntityItemRequirement {
    private final int[] activePlacements = new int[9];

    public HeadlampBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public List<HeadlampPlacement> getExistingPlacements() {
        ArrayList<HeadlampPlacement> placements = new ArrayList<HeadlampPlacement>();
        for (int i = 0; i < this.activePlacements.length; ++i) {
            if (this.activePlacements[i] == 0) continue;
            placements.add(HeadlampPlacement.values()[i]);
        }
        return placements;
    }

    public void tick() {
        super.tick();
    }

    public boolean placeHeadlampIntoBlock(Vec3 position, Direction clickedDirection) {
        List<HeadlampPlacement> existingPlacements;
        Vec3 localPosition = HeadlampBlockEntity.getLocalSurfacePosition(position, clickedDirection);
        HeadlampPlacement placement = HeadlampBlockEntity.getClosestHeadlampPlacement(localPosition);
        if (placement.hasCollisionWith(existingPlacements = this.getExistingPlacements())) {
            return false;
        }
        int index = placement.ordinal();
        this.activePlacements[index] = 1;
        this.sendData();
        return true;
    }

    public boolean canPlaceHeadlampIntoBlock(Vec3 position, Direction clickedDirection) {
        List<HeadlampPlacement> existingPlacements;
        Vec3 localPosition = HeadlampBlockEntity.getLocalSurfacePosition(position, clickedDirection);
        HeadlampPlacement placement = HeadlampBlockEntity.getClosestHeadlampPlacement(localPosition);
        return !placement.hasCollisionWith(existingPlacements = this.getExistingPlacements());
    }

    public void placeDyeColorIntoBlock(DyeColor dyeColor, Vec3 position, Direction value) {
        int i;
        Vec3 localPosition = HeadlampBlockEntity.getLocalSurfacePosition(position, value);
        HeadlampPlacement placement = this.getClosestExistingHeadlampPlacement(localPosition);
        if (placement == null) {
            return;
        }
        int index = placement.ordinal();
        if (this.activePlacements[index] == (i = dyeColor.ordinal() + 2)) {
            for (int j = 0; j < this.activePlacements.length; ++j) {
                if (this.activePlacements[j] == i || this.activePlacements[j] == 0) continue;
                return;
            }
            this.tryExtendPlaceDyeColorIntoFullBlock(dyeColor, (Direction)this.getBlockState().getValue((Property)HeadlampBlock.FACING), new ArrayList<BlockPos>(List.of(this.getBlockPos())), new ArrayList<BlockPos>());
            return;
        }
        this.activePlacements[index] = i;
        this.sendData();
    }

    private void tryExtendPlaceDyeColorIntoFullBlock(DyeColor dyeColor, Direction facing, List<BlockPos> frontier, List<BlockPos> visited) {
        HeadlampBlockEntity otherHeadlamp;
        if (frontier.isEmpty()) {
            return;
        }
        if (visited.size() > 32) {
            return;
        }
        BlockPos currentPos = frontier.remove(0);
        if (visited.contains(currentPos)) {
            this.tryExtendPlaceDyeColorIntoFullBlock(dyeColor, facing, frontier, visited);
            return;
        }
        visited.add(currentPos);
        BlockEntity blockEntity = this.level.getBlockEntity(currentPos);
        if (blockEntity instanceof HeadlampBlockEntity && (otherHeadlamp = (HeadlampBlockEntity)blockEntity).placeDyeColorIntoFullBlock(dyeColor)) {
            return;
        }
        List<Direction> directions = List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST, Direction.UP, Direction.DOWN).stream().filter(d -> d.getAxis() != facing.getAxis()).toList();
        for (Direction direction : directions) {
            frontier.add(currentPos.relative(direction));
        }
        this.tryExtendPlaceDyeColorIntoFullBlock(dyeColor, facing, frontier, visited);
    }

    public boolean removeNearestHeadlamp(Vec3 subtract, Direction value) {
        Vec3 localPosition = HeadlampBlockEntity.getLocalSurfacePosition(subtract, value);
        HeadlampPlacement closestPlacement = this.getClosestExistingHeadlampPlacement(localPosition);
        if (closestPlacement == null) {
            return false;
        }
        int index = closestPlacement.ordinal();
        this.activePlacements[index] = 0;
        this.sendData();
        if (this.getExistingPlacements().isEmpty()) {
            this.level.removeBlock(this.worldPosition, false);
        }
        return true;
    }

    @NotNull
    private static Vec3 getLocalSurfacePosition(Vec3 position, Direction value) {
        Vector3f jomlLocalPosition = value.getRotation().transformInverse(new Vector3f((float)position.x, (float)position.y, (float)position.z));
        Vec3 localPosition = new Vec3((double)jomlLocalPosition.x, (double)jomlLocalPosition.y, (double)jomlLocalPosition.z);
        return localPosition;
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        if (!tag.contains("activePlacements", 11)) {
            return;
        }
        int[] placements = tag.getIntArray("activePlacements");
        if (placements.length != this.activePlacements.length) {
            throw new IllegalStateException("Active placements length mismatch: expected " + this.activePlacements.length + ", got " + placements.length);
        }
        System.arraycopy(placements, 0, this.activePlacements, 0, placements.length);
        if (clientPacket) {
            this.requestModelDataUpdate();
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 16);
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        tag.putIntArray("activePlacements", this.activePlacements);
    }

    public static HeadlampPlacement getClosestHeadlampPlacement(Vec3 targetOnSurface) {
        return new HeadlampPlacement(HeadlampBlockEntity.getAlignmentFromOffset(targetOnSurface.z), HeadlampBlockEntity.getAlignmentFromOffset(targetOnSurface.x));
    }

    @Nullable
    private HeadlampPlacement getClosestExistingHeadlampPlacement(Vec3 localPosition) {
        HeadlampPlacement closestPlacement = null;
        double closestDistance = Double.MAX_VALUE;
        for (HeadlampPlacement placement : HeadlampPlacement.values()) {
            double distance;
            if (this.activePlacements[placement.ordinal()] == 0 || !((distance = Math.abs(localPosition.x - placement.horizontalAlignment.getOffset()) + Math.abs(localPosition.z - placement.verticalAlignment.getOffset())) < closestDistance)) continue;
            closestDistance = distance;
            closestPlacement = placement;
        }
        return closestPlacement;
    }

    private static HeadlampAlignment getAlignmentFromOffset(double offset) {
        if (offset < HeadlampAlignment.RIGHT_OR_BOTTOM.getOffset() / 2.0) {
            return HeadlampAlignment.RIGHT_OR_BOTTOM;
        }
        if (offset > HeadlampAlignment.LEFT_OR_TOP.getOffset() / 2.0) {
            return HeadlampAlignment.LEFT_OR_TOP;
        }
        return HeadlampAlignment.MIDDLE;
    }

    public int[] getActivePlacements() {
        return this.activePlacements;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        AllShapes.Builder builder = new AllShapes.Builder(Shapes.empty());
        List<HeadlampPlacement> placements = this.getExistingPlacements();
        if (placements.isEmpty()) {
            return Shapes.block();
        }
        for (HeadlampPlacement placement : placements) {
            if (this.activePlacements[placement.ordinal()] == 0) continue;
            builder.add(BnbShapes.cuboid(4 + placement.horizontalAlignment.pixelOffset, 0.0, 4 + placement.verticalAlignment.pixelOffset, 12 + placement.horizontalAlignment.pixelOffset, 7.0, 12 + placement.verticalAlignment.pixelOffset));
        }
        return builder.forDirectional().get((Direction)state.getValue((Property)HeadlampBlock.FACING));
    }

    public boolean placeDyeColorIntoFullBlock(DyeColor dyeColor) {
        boolean placedAny = false;
        int toAdd = dyeColor.ordinal() + 2;
        for (int i = 0; i < HeadlampPlacement.values().length; ++i) {
            if (this.activePlacements[i] == 0 || this.activePlacements[i] == toAdd) continue;
            placedAny = true;
            this.activePlacements[i] = toAdd;
        }
        if (!placedAny) {
            return false;
        }
        this.sendData();
        return true;
    }

    public ItemRequirement getRequiredItems(BlockState state) {
        int numberOfHeadlamps = -1;
        for (int placement : this.activePlacements) {
            if (placement == 0) continue;
            ++numberOfHeadlamps;
        }
        if (numberOfHeadlamps <= 0) {
            return ItemRequirement.NONE;
        }
        return new ItemRequirement(ItemRequirement.ItemUseType.CONSUME, BnbBlocks.HEADLAMP.asItem().getDefaultInstance().copyWithCount(numberOfHeadlamps));
    }

    public record HeadlampPlacement(HeadlampAlignment verticalAlignment, HeadlampAlignment horizontalAlignment) {
        private static final HeadlampPlacement[] VALUES = HeadlampPlacement.generateValues();

        private static HeadlampPlacement[] generateValues() {
            ArrayList<HeadlampPlacement> placements = new ArrayList<HeadlampPlacement>();
            for (HeadlampAlignment vertical : HeadlampAlignment.values()) {
                for (HeadlampAlignment horizontal : HeadlampAlignment.values()) {
                    placements.add(new HeadlampPlacement(vertical, horizontal));
                }
            }
            return placements.toArray(new HeadlampPlacement[0]);
        }

        public static HeadlampPlacement[] values() {
            return VALUES;
        }

        public boolean hasCollisionWith(List<HeadlampPlacement> existingPlacements) {
            for (HeadlampPlacement placement : existingPlacements) {
                if (!placement.horizontalAlignment.collidesWith(this.horizontalAlignment) || !placement.verticalAlignment.collidesWith(this.verticalAlignment)) continue;
                return true;
            }
            return false;
        }

        public int ordinal() {
            for (int i = 0; i < VALUES.length; ++i) {
                if (!VALUES[i].equals(this)) continue;
                return i;
            }
            throw new IllegalStateException("HeadlampPlacement not found in values array: " + String.valueOf(this));
        }
    }

    public static enum HeadlampAlignment {
        RIGHT_OR_BOTTOM(-4),
        MIDDLE(0),
        LEFT_OR_TOP(4);

        private final int pixelOffset;

        private HeadlampAlignment(int pixelOffset) {
            this.pixelOffset = pixelOffset;
        }

        public int getPixelOffset() {
            return this.pixelOffset;
        }

        public double getOffset() {
            return (double)this.pixelOffset / 16.0;
        }

        public boolean collidesWith(HeadlampAlignment horizontalAlignment) {
            return this == horizontalAlignment || this == MIDDLE || horizontalAlignment == MIDDLE;
        }
    }
}

