/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.CreateBitsnBobs;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import org.jetbrains.annotations.Nullable;

public class TextBlockSubAtlas {
    public static final TextBlockSubAtlas NIXIE_TEXT_SUB_ATLAS = new TextBlockSubAtlas(CreateBitsnBobs.asResource("block/nixie/text_atlas"), 512, 16, "ABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n1234567890(),.!?#$%\\@;:\n\ue000\ue001\ue002\ue003\ue004\ue005\ue006\ue007\ue008\ue009\ue00a\ue00b\ue00c\ue00d\ue00e\ue00f\ue010\ue011\ue012\ue013\ue014\ue015\ue016\ue017\ue018\ue019\ue01a\ue01b\ue01c\ue01d\ue01e\ue01f\n".trim()).andExcludeColorsFor("\ue000\ue001\ue002\ue003\ue004\ue005\ue006\ue007\ue008\ue009\ue00a\ue00b\ue00c\ue00d\ue00e\ue00f\ue010\ue011\ue012\ue014\ue015\ue016\ue017\ue018\ue019\ue01a\ue01b\ue01c\ue01d\ue01e\ue01f");
    public static final TextBlockSubAtlas SMALL_NIXIE_TEXT_SUB_ATLAS = NIXIE_TEXT_SUB_ATLAS.withAllowedCharacters("\ue000\ue001\ue002\ue003\ue004\ue005\ue006\ue007\ue008\ue009\ue00a\ue00b\ue00c\ue00d\ue00e\ue00f\ue010\ue011\ue012\ue013\ue014\ue015\ue016\ue017\ue018\ue019\ue01a\ue01b\ue01c\ue01d\ue01e\ue01f");
    private final ResourceLocation atlasLocation;
    private final Map<Integer, Uv> characterUvs;
    @Nullable
    private final Set<Integer> allowedCharacters;
    @Nullable
    private Set<Integer> colorExcludedCharacters;

    public TextBlockSubAtlas(ResourceLocation atlasLocation, int textureSize, int elementSize, String characterSet, @Nullable String allowedCharacters) {
        float v1;
        float u1;
        float v0;
        float u0;
        this.atlasLocation = atlasLocation;
        this.colorExcludedCharacters = null;
        this.allowedCharacters = allowedCharacters != null ? allowedCharacters.chars().boxed().collect(Collectors.toSet()) : null;
        HashMap<Character, Uv> localUvs = new HashMap<Character, Uv>();
        float step = (float)textureSize / (float)elementSize;
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < characterSet.length(); ++i) {
            char c = characterSet.charAt(i);
            if (c == '\n') {
                x = 0.0f;
                y += step;
                continue;
            }
            u0 = x / (float)textureSize;
            v0 = y / (float)textureSize;
            u1 = (x + step) / (float)textureSize;
            v1 = (y + step) / (float)textureSize;
            localUvs.put(Character.valueOf(c), new Uv(u0, v0, u1, v1));
            x += step;
            if (!(x >= (float)textureSize)) continue;
            x = 0.0f;
            y += step;
        }
        HashMap<Integer, Uv> blockAtlasUvs = new HashMap<Integer, Uv>();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(atlasLocation);
        u0 = sprite.getU0();
        v0 = sprite.getV0();
        u1 = sprite.getU1();
        v1 = sprite.getV1();
        for (Map.Entry entry : localUvs.entrySet()) {
            char c = ((Character)entry.getKey()).charValue();
            Uv local = (Uv)entry.getValue();
            blockAtlasUvs.put(Integer.valueOf(c), new Uv(u0 + local.u0 * (u1 - u0), v0 + local.v0 * (v1 - v0), u0 + local.u1 * (u1 - u0), v0 + local.v1 * (v1 - v0)));
        }
        this.characterUvs = blockAtlasUvs;
    }

    public TextBlockSubAtlas(ResourceLocation atlasLocation, int textureSize, int elementSize, String characterSet) {
        this(atlasLocation, textureSize, elementSize, characterSet, null);
    }

    private TextBlockSubAtlas(TextBlockSubAtlas parent, String allowedCharacters) {
        this.atlasLocation = parent.atlasLocation;
        this.allowedCharacters = allowedCharacters.chars().boxed().collect(Collectors.toSet());
        this.characterUvs = parent.characterUvs;
        this.colorExcludedCharacters = parent.colorExcludedCharacters;
    }

    public TextBlockSubAtlas withAllowedCharacters(String allowedCharacters) {
        return new TextBlockSubAtlas(this, allowedCharacters);
    }

    private TextBlockSubAtlas andExcludeColorsFor(String colorExcludedCharacters) {
        this.colorExcludedCharacters = colorExcludedCharacters.chars().boxed().collect(Collectors.toSet());
        return this;
    }

    public ResourceLocation getAtlasLocation() {
        return this.atlasLocation;
    }

    public boolean isInCharacterSet(int c) {
        return this.characterUvs.containsKey(c) && (this.allowedCharacters == null || this.allowedCharacters.contains(c));
    }

    public Uv getUvForCharacter(int c) {
        return this.characterUvs.getOrDefault(c, new Uv(0.0f, 0.0f, 0.0f, 0.0f));
    }

    public boolean isInColorExcludedCharacterSet(int charCode) {
        return this.colorExcludedCharacters != null && this.colorExcludedCharacters.contains(charCode);
    }

    public static class Uv {
        public final float u0;
        public final float v0;
        public final float u1;
        public final float v1;

        public Uv(float u0, float v0, float u1, float v1) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
        }

        public float getU0() {
            return this.u0;
        }

        public float getV0() {
            return this.v0;
        }

        public float getU1() {
            return this.u1;
        }

        public float getV1() {
            return this.v1;
        }
    }
}

