/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.palette;

import com.google.common.collect.ImmutableMap;
import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.palette.BnbPaletteBlockPattern;
import com.kipti.bnb.registry.BnbPaletteStoneTypes;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.TagGen;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.DataIngredient;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.nullness.NonnullType;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.createmod.catnip.lang.Lang;
import net.minecraft.core.Direction;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.client.model.generators.MultiPartBlockStateBuilder;
import org.jetbrains.annotations.NotNull;

public abstract class BnbPaletteBlockPartial<B extends Block> {
    public static final BnbPaletteBlockPartial<StairBlock> STAIR = new Stairs();
    public static final BnbPaletteBlockPartial<SlabBlock> SLAB = new Slab(false);
    public static final BnbPaletteBlockPartial<SlabBlock> UNIQUE_SLAB = new Slab(true);
    public static final BnbPaletteBlockPartial<WallBlock> WALL = new Wall();
    public static final BnbPaletteBlockPartial<StairBlock> TILE_STAIR = new TileStairs();
    public static final BnbPaletteBlockPartial<SlabBlock> TILE_SLAB = new TileSlab();
    public static final BnbPaletteBlockPartial<WallBlock> TILE_WALL = new TileWall();
    public static final BnbPaletteBlockPartial<?>[] ALL_PARTIALS = new BnbPaletteBlockPartial[]{STAIR, SLAB, WALL};
    public static final BnbPaletteBlockPartial<?>[] ALL_PARTIALS_TILE = new BnbPaletteBlockPartial[]{TILE_STAIR, TILE_SLAB, TILE_WALL};
    public static final BnbPaletteBlockPartial<?>[] FOR_POLISHED = new BnbPaletteBlockPartial[]{STAIR, UNIQUE_SLAB, WALL};
    private final String name;

    private BnbPaletteBlockPartial(String name) {
        this.name = name;
    }

    @NonnullType
    public BlockBuilder<B, CreateRegistrate> create(String variantName, BnbPaletteBlockPattern pattern, BlockEntry<? extends Block> block, BnbPaletteStoneTypes variant) {
        String patternName = Lang.nonPluralId((String)pattern.createName(variantName));
        String blockName = patternName + "_" + this.name;
        BlockBuilder blockBuilder = (BlockBuilder)CreateBitsnBobs.REGISTRATE.block(blockName, p -> this.createBlock((Supplier<Block>)block)).blockstate((c, p) -> this.generateBlockState((DataGenContext<Block, B>)c, (RegistrateBlockstateProvider)p, variantName, pattern, (Supplier<? extends Block>)((Supplier<Block>)block))).recipe((c, p) -> this.createRecipes(variant, (BlockEntry<? extends Block>)((BlockEntry<Block>)block), (DataGenContext<Block, ? extends Block>)((DataGenContext<Block, Block>)c), (RegistrateRecipeProvider)p)).transform(b -> this.transformBlock((BlockBuilder<B, CreateRegistrate>)b, variantName, pattern));
        ItemBuilder itemBuilder = (ItemBuilder)blockBuilder.item().transform(b -> this.transformItem((ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>>)b, variantName, pattern));
        if (this.canRecycle()) {
            itemBuilder.tag(new TagKey[]{variant.materialTag});
        }
        return (BlockBuilder)itemBuilder.build();
    }

    protected ResourceLocation getTexture(String variantName, BnbPaletteBlockPattern pattern, int index) {
        return BnbPaletteBlockPattern.toLocation(variantName, pattern.getTexture(index));
    }

    protected ResourceLocation getFlippedTexture(String variantName, BnbPaletteBlockPattern pattern, int index) {
        return BnbPaletteBlockPattern.toLocation(variantName, pattern.getTexture(index) + "_flipped");
    }

    protected BlockBuilder<B, CreateRegistrate> transformBlock(BlockBuilder<B, CreateRegistrate> builder, String variantName, BnbPaletteBlockPattern pattern) {
        this.getBlockTags().forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        return (BlockBuilder)builder.transform(TagGen.pickaxeOnly());
    }

    protected ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<B, CreateRegistrate>> builder, String variantName, BnbPaletteBlockPattern pattern) {
        this.getItemTags().forEach(xva$0 -> builder.tag(new TagKey[]{xva$0}));
        return builder;
    }

    protected boolean canRecycle() {
        return true;
    }

    protected abstract Iterable<TagKey<Block>> getBlockTags();

    protected abstract Iterable<TagKey<Item>> getItemTags();

    protected abstract B createBlock(Supplier<? extends Block> var1);

    protected abstract void createRecipes(BnbPaletteStoneTypes var1, BlockEntry<? extends Block> var2, DataGenContext<Block, ? extends Block> var3, RegistrateRecipeProvider var4);

    protected abstract void generateBlockState(DataGenContext<Block, B> var1, RegistrateBlockstateProvider var2, String var3, BnbPaletteBlockPattern var4, Supplier<? extends Block> var5);

    private static class Stairs
    extends BnbPaletteBlockPartial<StairBlock> {
        public Stairs() {
            super("stairs");
        }

        @Override
        protected StairBlock createBlock(Supplier<? extends Block> block) {
            return new StairBlock(block.get().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, StairBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BnbPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            prov.stairsBlock((StairBlock)ctx.get(), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.STAIRS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.STAIRS);
        }

        @Override
        protected void createRecipes(BnbPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.stairs(DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]), category, c, c.getName(), false);
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 1);
        }
    }

    private static class Slab
    extends BnbPaletteBlockPartial<SlabBlock> {
        private final boolean customSide;

        public Slab(boolean customSide) {
            super("slab");
            this.customSide = customSide;
        }

        @Override
        protected SlabBlock createBlock(Supplier<? extends Block> block) {
            return new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected boolean canRecycle() {
            return false;
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BnbPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            String name = ctx.getName();
            ResourceLocation mainTexture = this.getTexture(variantName, pattern, 0);
            ResourceLocation sideTexture = this.customSide ? this.getTexture(variantName, pattern, 1) : mainTexture;
            ModelBuilder bottom = prov.models().slab(name, sideTexture, mainTexture, mainTexture);
            ModelBuilder top = prov.models().slabTop(name + "_top", sideTexture, mainTexture, mainTexture);
            Object doubleSlab = this.customSide ? prov.models().cubeColumn(name + "_double", sideTexture, mainTexture) : prov.models().getExistingFile(prov.modLoc(pattern.createName(variantName)));
            prov.slabBlock((SlabBlock)ctx.get(), (ModelFile)bottom, (ModelFile)top, (ModelFile)doubleSlab);
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.SLABS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.SLABS);
        }

        @Override
        protected void createRecipes(BnbPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.slab(DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]), category, c, c.getName(), false);
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 2);
            DataIngredient ingredient = DataIngredient.items((ItemLike)((Block)c.get()), (ItemLike[])new Block[0]);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)((ItemLike)patternBlock.get())).requires(ingredient.toVanilla()).requires(ingredient.toVanilla()).unlockedBy("has_" + c.getName(), ingredient.getCriterion(p)).save((RecipeOutput)p, "create:" + c.getName() + "_recycling");
        }

        @Override
        protected BlockBuilder<SlabBlock, CreateRegistrate> transformBlock(BlockBuilder<SlabBlock, CreateRegistrate> builder, String variantName, BnbPaletteBlockPattern pattern) {
            builder.loot((lt, block) -> lt.add((Block)block, lt.createSlabItemTable((Block)block)));
            return super.transformBlock(builder, variantName, pattern);
        }
    }

    private static class Wall
    extends BnbPaletteBlockPartial<WallBlock> {
        public Wall() {
            super("wall");
        }

        @Override
        protected WallBlock createBlock(Supplier<? extends Block> block) {
            return new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())).forceSolidOn());
        }

        @Override
        protected ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> builder, String variantName, BnbPaletteBlockPattern pattern) {
            builder.model((c, p) -> p.wallInventory(c.getName(), this.getTexture(variantName, pattern, 0)));
            return super.transformItem(builder, variantName, pattern);
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, WallBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BnbPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            prov.wallBlock((WallBlock)ctx.get(), pattern.createName(variantName), this.getTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.WALLS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.WALLS);
        }

        @Override
        protected void createRecipes(BnbPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 1);
            DataIngredient ingredient = DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]);
            ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)((ItemLike)c.get()), (int)6).pattern("XXX").pattern("XXX").define(Character.valueOf('X'), ingredient.toVanilla()).unlockedBy("has_" + p.safeName(ingredient), ingredient.getCriterion(p)).save((RecipeOutput)p, p.safeId((ItemLike)c.get()));
        }
    }

    private static class TileStairs
    extends BnbPaletteBlockPartial<StairBlock> {
        public TileStairs() {
            super("stairs");
        }

        @Override
        protected StairBlock createBlock(Supplier<? extends Block> block) {
            return new StairBlock(block.get().defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, StairBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BnbPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            String name = ctx.getName();
            ResourceLocation mainTexture = this.getTexture(variantName, pattern, 0);
            ResourceLocation flippedTexture = this.getFlippedTexture(variantName, pattern, 0);
            BlockModelBuilder stairs = TileStairs.getStairModel(prov, name, "block/tile_stairs/stairs", mainTexture, flippedTexture);
            BlockModelBuilder stairsAlternate = TileStairs.getStairModel(prov, name + "_alternate", "block/tile_stairs/stairs_alternate", mainTexture, flippedTexture);
            BlockModelBuilder stairsInner = TileStairs.getStairModel(prov, name + "_inner", "block/tile_stairs/inner_stairs", mainTexture, flippedTexture);
            BlockModelBuilder stairsInnerAlternate = TileStairs.getStairModel(prov, name + "_inner_alternate", "block/tile_stairs/inner_stairs_alternate", mainTexture, flippedTexture);
            BlockModelBuilder stairsOuter = TileStairs.getStairModel(prov, name + "_outer", "block/tile_stairs/outer_stairs", mainTexture, flippedTexture);
            BlockModelBuilder stairsOuterAlternate = TileStairs.getStairModel(prov, name + "_outer_alternate", "block/tile_stairs/outer_stairs_alternate", mainTexture, flippedTexture);
            prov.getVariantBuilder((Block)ctx.get()).forAllStatesExcept(arg_0 -> TileStairs.lambda$generateBlockState$0((ModelFile)stairsAlternate, (ModelFile)stairs, (ModelFile)stairsInnerAlternate, (ModelFile)stairsInner, (ModelFile)stairsOuterAlternate, (ModelFile)stairsOuter, arg_0), new Property[]{StairBlock.WATERLOGGED});
        }

        @NotNull
        private static BlockModelBuilder getStairModel(RegistrateBlockstateProvider prov, String name, String s, ResourceLocation mainTexture, ResourceLocation flippedTexture) {
            return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, CreateBitsnBobs.asResource(s))).texture("side", mainTexture)).texture("side_flipped", flippedTexture)).texture("bottom", mainTexture)).texture("top", mainTexture);
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.STAIRS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.STAIRS);
        }

        @Override
        protected void createRecipes(BnbPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.stairs(DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]), category, c, c.getName(), false);
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 1);
        }

        private static /* synthetic */ ConfiguredModel[] lambda$generateBlockState$0(ModelFile stairsAlternate, ModelFile stairs, ModelFile stairsInnerAlternate, ModelFile stairsInner, ModelFile stairsOuterAlternate, ModelFile stairsOuter, BlockState state) {
            Direction facing = (Direction)state.getValue((Property)StairBlock.FACING);
            Half half = (Half)state.getValue((Property)StairBlock.HALF);
            StairsShape shape = (StairsShape)state.getValue((Property)StairBlock.SHAPE);
            int yRot = (int)facing.getClockWise().toYRot();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            boolean alternate = (yRot %= 360) % 180 != 0;
            boolean uvlock = yRot != 0 || half == Half.TOP;
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? (alternate ? stairsAlternate : stairs) : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? (alternate ? stairsInnerAlternate : stairsInner) : (alternate ? stairsOuterAlternate : stairsOuter))).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot).uvLock(uvlock).build();
        }
    }

    private static class TileSlab
    extends BnbPaletteBlockPartial<SlabBlock> {
        public TileSlab() {
            super("slab");
        }

        @Override
        protected SlabBlock createBlock(Supplier<? extends Block> block) {
            return new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())));
        }

        @Override
        protected boolean canRecycle() {
            return false;
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, SlabBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BnbPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            String name = ctx.getName();
            ResourceLocation mainTexture = this.getTexture(variantName, pattern, 0);
            ResourceLocation flippedTexture = this.getFlippedTexture(variantName, pattern, 0);
            ModelBuilder bottom = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name, CreateBitsnBobs.asResource("block/tile_slab/slab"))).texture("side", mainTexture)).texture("side_flipped", flippedTexture)).texture("bottom", mainTexture)).texture("top", mainTexture);
            ModelBuilder top = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(name + "_top", CreateBitsnBobs.asResource("block/tile_slab/slab_top"))).texture("side", mainTexture)).texture("side_flipped", flippedTexture)).texture("bottom", mainTexture)).texture("top", mainTexture);
            ModelFile.ExistingModelFile doubleSlab = prov.models().getExistingFile(prov.modLoc(pattern.createName(variantName)));
            prov.slabBlock((SlabBlock)ctx.get(), (ModelFile)bottom, (ModelFile)top, (ModelFile)doubleSlab);
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.SLABS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.SLABS);
        }

        @Override
        protected void createRecipes(BnbPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.slab(DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]), category, c, c.getName(), false);
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 2);
            DataIngredient ingredient = DataIngredient.items((ItemLike)((Block)c.get()), (ItemLike[])new Block[0]);
            ShapelessRecipeBuilder.shapeless((RecipeCategory)category, (ItemLike)((ItemLike)patternBlock.get())).requires(ingredient.toVanilla()).requires(ingredient.toVanilla()).unlockedBy("has_" + c.getName(), ingredient.getCriterion(p)).save((RecipeOutput)p, "create:" + c.getName() + "_recycling");
        }

        @Override
        protected BlockBuilder<SlabBlock, CreateRegistrate> transformBlock(BlockBuilder<SlabBlock, CreateRegistrate> builder, String variantName, BnbPaletteBlockPattern pattern) {
            builder.loot((lt, block) -> lt.add((Block)block, lt.createSlabItemTable((Block)block)));
            return super.transformBlock(builder, variantName, pattern);
        }
    }

    private static class TileWall
    extends BnbPaletteBlockPartial<WallBlock> {
        public static final ImmutableMap<Direction, Property<WallSide>> WALL_PROPS = ImmutableMap.builder().put((Object)Direction.EAST, (Object)BlockStateProperties.EAST_WALL).put((Object)Direction.NORTH, (Object)BlockStateProperties.NORTH_WALL).put((Object)Direction.SOUTH, (Object)BlockStateProperties.SOUTH_WALL).put((Object)Direction.WEST, (Object)BlockStateProperties.WEST_WALL).build();

        public TileWall() {
            super("wall");
        }

        @Override
        protected WallBlock createBlock(Supplier<? extends Block> block) {
            return new WallBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)((BlockBehaviour)block.get())).forceSolidOn());
        }

        @Override
        protected ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> transformItem(ItemBuilder<BlockItem, BlockBuilder<WallBlock, CreateRegistrate>> builder, String variantName, BnbPaletteBlockPattern pattern) {
            ResourceLocation wallTexture = this.getTexture(variantName, pattern, 0);
            ResourceLocation wallTextureFlipped = this.getFlippedTexture(variantName, pattern, 0);
            builder.model((c, p) -> ((ItemModelBuilder)p.singleTexture(c.getName(), CreateBitsnBobs.asResource("block/tile_wall/wall_inventory"), "wall", wallTexture)).texture("wall_flipped", wallTextureFlipped));
            return super.transformItem(builder, variantName, pattern);
        }

        public BlockModelBuilder tileWallPost(RegistrateBlockstateProvider p, String name, ResourceLocation wall, ResourceLocation wallFlipped) {
            return (BlockModelBuilder)((BlockModelBuilder)p.models().singleTexture(name, CreateBitsnBobs.asResource("block/tile_wall/template_wall_post"), "wall", wall)).texture("wall_flipped", wallFlipped);
        }

        public BlockModelBuilder tileWallSide(RegistrateBlockstateProvider p, String name, ResourceLocation wall, ResourceLocation wallFlipped) {
            return (BlockModelBuilder)((BlockModelBuilder)p.models().singleTexture(name, CreateBitsnBobs.asResource("block/tile_wall/template_wall_side"), "wall", wall)).texture("wall_flipped", wallFlipped);
        }

        public BlockModelBuilder tileWallSideTall(RegistrateBlockstateProvider p, String name, ResourceLocation wall, ResourceLocation wallFlipped) {
            return (BlockModelBuilder)((BlockModelBuilder)p.models().singleTexture(name, CreateBitsnBobs.asResource("block/tile_wall/template_wall_side_tall"), "wall", wall)).texture("wall_flipped", wallFlipped);
        }

        public BlockModelBuilder tileWallSideAlternate(RegistrateBlockstateProvider p, String name, ResourceLocation wall, ResourceLocation wallFlipped) {
            return (BlockModelBuilder)((BlockModelBuilder)p.models().singleTexture(name, CreateBitsnBobs.asResource("block/tile_wall/template_wall_side_alternate"), "wall", wall)).texture("wall_flipped", wallFlipped);
        }

        public BlockModelBuilder tileWallSideTallAlternate(RegistrateBlockstateProvider p, String name, ResourceLocation wall, ResourceLocation wallFlipped) {
            return (BlockModelBuilder)((BlockModelBuilder)p.models().singleTexture(name, CreateBitsnBobs.asResource("block/tile_wall/template_wall_side_tall_alternate"), "wall", wall)).texture("wall_flipped", wallFlipped);
        }

        private void tileWallBlockInternal(RegistrateBlockstateProvider p, WallBlock block, String baseName, ResourceLocation texture, ResourceLocation flippedTexture) {
            this.tileWallBlock(p, block, (ModelFile)this.tileWallPost(p, baseName + "_post", texture, flippedTexture), (ModelFile)this.tileWallSide(p, baseName + "_side", texture, flippedTexture), (ModelFile)this.tileWallSideAlternate(p, baseName + "_side_alternate", texture, flippedTexture), (ModelFile)this.tileWallSideTall(p, baseName + "_side_tall", texture, flippedTexture), (ModelFile)this.tileWallSideTallAlternate(p, baseName + "_side_tall_alternate", texture, flippedTexture));
        }

        public void tileWallBlock(RegistrateBlockstateProvider p, WallBlock block, ModelFile post, ModelFile side, ModelFile sideAlternate, ModelFile sideTall, ModelFile sideTallAlternate) {
            MultiPartBlockStateBuilder builder = ((MultiPartBlockStateBuilder.PartBuilder)p.getMultipartBuilder((Block)block).part().modelFile(post).addModel()).condition((Property)WallBlock.UP, (Comparable[])new Boolean[]{true}).end();
            WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).getAxis().isHorizontal()).forEach(e -> {
                this.tileWallSidePart(builder, side, sideAlternate, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW);
                this.tileWallSidePart(builder, sideTall, sideTallAlternate, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL);
            });
        }

        private void tileWallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, ModelFile modelAlternate, Map.Entry<Direction, Property<WallSide>> entry, WallSide height) {
            int yRot = ((int)entry.getKey().toYRot() + 180) % 360;
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(yRot == 0 || yRot == 180 ? model : modelAlternate).rotationY(yRot).uvLock(true).addModel()).condition(entry.getValue(), (Comparable[])new WallSide[]{height});
        }

        public void tileWallBlock(RegistrateBlockstateProvider p, WallBlock block, String name, ResourceLocation texture, ResourceLocation flippedTexture) {
            this.tileWallBlockInternal(p, block, name + "_wall", texture, flippedTexture);
        }

        @Override
        protected void generateBlockState(DataGenContext<Block, WallBlock> ctx, RegistrateBlockstateProvider prov, String variantName, BnbPaletteBlockPattern pattern, Supplier<? extends Block> block) {
            this.tileWallBlock(prov, (WallBlock)ctx.get(), pattern.createName(variantName), this.getTexture(variantName, pattern, 0), this.getFlippedTexture(variantName, pattern, 0));
        }

        @Override
        protected Iterable<TagKey<Block>> getBlockTags() {
            return List.of(BlockTags.WALLS);
        }

        @Override
        protected Iterable<TagKey<Item>> getItemTags() {
            return List.of(ItemTags.WALLS);
        }

        @Override
        protected void createRecipes(BnbPaletteStoneTypes type, BlockEntry<? extends Block> patternBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
            RecipeCategory category = RecipeCategory.BUILDING_BLOCKS;
            p.stonecutting(DataIngredient.tag(type.materialTag), category, c, 1);
            DataIngredient ingredient = DataIngredient.items((ItemLike)((Block)patternBlock.get()), (ItemLike[])new Block[0]);
            ShapedRecipeBuilder.shaped((RecipeCategory)category, (ItemLike)((ItemLike)c.get()), (int)6).pattern("XXX").pattern("XXX").define(Character.valueOf('X'), ingredient.toVanilla()).unlockedBy("has_" + p.safeName(ingredient), ingredient.getCriterion(p)).save((RecipeOutput)p, p.safeId((ItemLike)c.get()));
        }
    }
}

