/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.palette;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.content.palette.BnbPaletteBlockPartial;
import com.simibubi.create.content.decoration.palettes.ConnectedPillarBlock;
import com.simibubi.create.foundation.block.connected.AllCTTypes;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.CTSpriteShifter;
import com.simibubi.create.foundation.block.connected.CTType;
import com.simibubi.create.foundation.block.connected.ConnectedTextureBehaviour;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BnbPaletteBlockPattern {
    public static final BnbPaletteBlockPattern TILES = BnbPaletteBlockPattern.create("tiles", BnbPatternNameType.SUFFIX, BnbPaletteBlockPartial.ALL_PARTIALS_TILE).blockStateFactory(p -> p::cubeTile);
    public static final BnbPaletteBlockPattern[] ADDITIONS_TO_BASE = new BnbPaletteBlockPattern[]{TILES};
    static final String TEXTURE_LOCATION = "block/palettes/stone_types/%s/%s";
    private BnbPatternNameType nameType;
    private String[] textures;
    private String id;
    private boolean isTranslucent;
    private TagKey<Block>[] blockTags;
    private TagKey<Item>[] itemTags;
    private Optional<Function<String, ConnectedTextureBehaviour>> ctFactory;
    private IPatternBlockStateGenerator blockStateGenerator;
    private NonNullFunction<BlockBehaviour.Properties, ? extends Block> blockFactory;
    private NonNullFunction<NonNullSupplier<Block>, NonNullBiConsumer<DataGenContext<Block, ? extends Block>, RegistrateRecipeProvider>> additionalRecipes;
    private BnbPaletteBlockPartial<? extends Block>[] partials;
    @OnlyIn(value=Dist.CLIENT)
    private RenderType renderType;

    private static BnbPaletteBlockPattern create(String name, BnbPatternNameType nameType, BnbPaletteBlockPartial<?> ... partials) {
        BnbPaletteBlockPattern pattern = new BnbPaletteBlockPattern();
        pattern.id = name;
        pattern.ctFactory = Optional.empty();
        pattern.nameType = nameType;
        pattern.partials = partials;
        pattern.additionalRecipes = $ -> NonNullBiConsumer.noop();
        pattern.isTranslucent = false;
        pattern.blockFactory = Block::new;
        pattern.textures = new String[]{name};
        pattern.blockStateGenerator = p -> p::cubeAll;
        return pattern;
    }

    public IPatternBlockStateGenerator getBlockStateGenerator() {
        return this.blockStateGenerator;
    }

    public boolean isTranslucent() {
        return this.isTranslucent;
    }

    public TagKey<Block>[] getBlockTags() {
        return this.blockTags;
    }

    public TagKey<Item>[] getItemTags() {
        return this.itemTags;
    }

    public NonNullFunction<BlockBehaviour.Properties, ? extends Block> getBlockFactory() {
        return this.blockFactory;
    }

    public BnbPaletteBlockPartial<? extends Block>[] getPartials() {
        return this.partials;
    }

    public String getTexture(int index) {
        return this.textures[index];
    }

    public void addRecipes(NonNullSupplier<Block> baseBlock, DataGenContext<Block, ? extends Block> c, RegistrateRecipeProvider p) {
        ((NonNullBiConsumer)this.additionalRecipes.apply(baseBlock)).accept(c, (Object)p);
    }

    public Optional<Supplier<ConnectedTextureBehaviour>> createCTBehaviour(String variant) {
        return this.ctFactory.map(d -> () -> (ConnectedTextureBehaviour)d.apply(variant));
    }

    private BnbPaletteBlockPattern blockStateFactory(IPatternBlockStateGenerator factory) {
        this.blockStateGenerator = factory;
        return this;
    }

    private BnbPaletteBlockPattern textures(String ... textures) {
        this.textures = textures;
        return this;
    }

    private BnbPaletteBlockPattern block(NonNullFunction<BlockBehaviour.Properties, ? extends Block> blockFactory) {
        this.blockFactory = blockFactory;
        return this;
    }

    private BnbPaletteBlockPattern connectedTextures(Function<String, ConnectedTextureBehaviour> factory) {
        this.ctFactory = Optional.of(factory);
        return this;
    }

    public IBlockStateProvider cubeAll(String variant) {
        ResourceLocation all = BnbPaletteBlockPattern.toLocation(variant, this.textures[0]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeAll(this.createName(variant), all));
    }

    public IBlockStateProvider cubeTile(String variant) {
        ResourceLocation all = BnbPaletteBlockPattern.toLocation(variant, this.textures[0]);
        ResourceLocation flipped = BnbPaletteBlockPattern.toLocation(variant, this.textures[0] + "_flipped");
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)((BlockModelBuilder)prov.models().cube(this.createName(variant), all, all, flipped, flipped, all, all)).texture("particle", all));
    }

    public IBlockStateProvider cubeBottomTop(String variant) {
        ResourceLocation side = BnbPaletteBlockPattern.toLocation(variant, this.textures[0]);
        ResourceLocation bottom = BnbPaletteBlockPattern.toLocation(variant, this.textures[1]);
        ResourceLocation top = BnbPaletteBlockPattern.toLocation(variant, this.textures[2]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeBottomTop(this.createName(variant), side, bottom, top));
    }

    public IBlockStateProvider pillar(String variant) {
        ResourceLocation side = BnbPaletteBlockPattern.toLocation(variant, this.textures[0]);
        ResourceLocation end = BnbPaletteBlockPattern.toLocation(variant, this.textures[1]);
        return (ctx, prov) -> prov.getVariantBuilder((Block)ctx.getEntry()).forAllStatesExcept(state -> {
            Direction.Axis axis = (Direction.Axis)state.getValue((Property)BlockStateProperties.AXIS);
            if (axis == Direction.Axis.Y) {
                return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeColumn(this.createName(variant), side, end)).uvLock(false).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)prov.models().cubeColumnHorizontal(this.createName(variant) + "_horizontal", side, end)).uvLock(false).rotationX(90).rotationY(axis == Direction.Axis.X ? 90 : 0).build();
        }, new Property[]{BlockStateProperties.WATERLOGGED, ConnectedPillarBlock.NORTH, ConnectedPillarBlock.SOUTH, ConnectedPillarBlock.EAST, ConnectedPillarBlock.WEST});
    }

    public IBlockStateProvider cubeColumn(String variant) {
        ResourceLocation side = BnbPaletteBlockPattern.toLocation(variant, this.textures[0]);
        ResourceLocation end = BnbPaletteBlockPattern.toLocation(variant, this.textures[1]);
        return (ctx, prov) -> prov.simpleBlock((Block)ctx.get(), (ModelFile)prov.models().cubeColumn(this.createName(variant), side, end));
    }

    protected String createName(String variant) {
        String[] split;
        if (this.nameType == BnbPatternNameType.WRAP && (split = this.id.split("_")).length == 2) {
            String formatString = "%s_%s_%s";
            return String.format("%s_%s_%s", split[0], variant, split[1]);
        }
        String formatString = "%s_%s";
        return this.nameType == BnbPatternNameType.SUFFIX ? String.format("%s_%s", variant, this.id) : String.format("%s_%s", this.id, variant);
    }

    protected static ResourceLocation toLocation(String variant, String texture) {
        return CreateBitsnBobs.asResource(String.format(TEXTURE_LOCATION, texture, variant + (texture.equals("cut") ? "_" : "_cut_") + texture));
    }

    protected static CTSpriteShiftEntry ct(String variant, CTs texture) {
        ResourceLocation resLoc = texture.srcFactory.apply(variant);
        ResourceLocation resLocTarget = texture.targetFactory.apply(variant);
        return CTSpriteShifter.getCT((CTType)texture.type, (ResourceLocation)resLoc, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)resLocTarget.getNamespace(), (String)(resLocTarget.getPath() + "_connected")));
    }

    public static enum BnbPatternNameType {
        PREFIX,
        SUFFIX,
        WRAP;

    }

    @FunctionalInterface
    public static interface IPatternBlockStateGenerator
    extends Function<BnbPaletteBlockPattern, Function<String, IBlockStateProvider>> {
    }

    @FunctionalInterface
    public static interface IBlockStateProvider
    extends NonNullBiConsumer<DataGenContext<Block, ? extends Block>, RegistrateBlockstateProvider> {
    }

    public static enum CTs {
        PILLAR((CTType)AllCTTypes.RECTANGLE, s -> BnbPaletteBlockPattern.toLocation(s, "pillar")),
        CAP((CTType)AllCTTypes.OMNIDIRECTIONAL, s -> BnbPaletteBlockPattern.toLocation(s, "cap")),
        LAYERED((CTType)AllCTTypes.HORIZONTAL_KRYPPERS, s -> BnbPaletteBlockPattern.toLocation(s, "layered"));

        public CTType type;
        private Function<String, ResourceLocation> srcFactory;
        private Function<String, ResourceLocation> targetFactory;

        private CTs(CTType type, Function<String, ResourceLocation> factory) {
            this(type, factory, factory);
        }

        private CTs(CTType type, Function<String, ResourceLocation> srcFactory, Function<String, ResourceLocation> targetFactory) {
            this.type = type;
            this.srcFactory = srcFactory;
            this.targetFactory = targetFactory;
        }
    }

    static enum PatternNameType {
        PREFIX,
        SUFFIX,
        WRAP;

    }
}

