/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.foundation.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.createmod.catnip.outliner.LineOutline;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3d;
import org.joml.Vector4f;

public class ExpandingLineOutline
extends LineOutline {
    protected int growingTicksElapsed = 0;
    protected int growingTicks;

    public ExpandingLineOutline setGrowingTicks(int growingTicks) {
        this.growingTicks = growingTicks;
        return this;
    }

    public ExpandingLineOutline setGrowingTicksElapsed(int growingTicksElapsed) {
        this.growingTicksElapsed = growingTicksElapsed;
        return this;
    }

    public ExpandingLineOutline tickGrowingTicksElapsed() {
        ++this.growingTicksElapsed;
        return this;
    }

    protected void renderInner(@NotNull PoseStack ms, @NotNull VertexConsumer consumer, @NotNull Vec3 camera, float pt, float width, @NotNull Vector4f color, int lightmap, boolean disableNormals) {
        this.bufferCuboidLine(ms, consumer, camera, this.lerpGrowingLinePoint(this.start, pt), this.lerpGrowingLinePoint(this.end, pt), width, color, lightmap, disableNormals);
    }

    private Vector3d lerpGrowingLinePoint(Vector3d point, float pt) {
        float progress = Math.min(1.0f, ((float)this.growingTicksElapsed + pt) / (float)this.growingTicks);
        float oneMinusProgress = 1.0f - progress;
        float easedProgress = 1.0f - oneMinusProgress * oneMinusProgress * oneMinusProgress;
        Vector3d midpoint = new Vector3d((this.start.x + this.end.x) / 2.0, (this.start.y + this.end.y) / 2.0, (this.start.z + this.end.z) / 2.0);
        return new Vector3d(midpoint.x + (point.x - midpoint.x) * (double)easedProgress, midpoint.y + (point.y - midpoint.y) * (double)easedProgress, midpoint.z + (point.z - midpoint.z) * (double)easedProgress);
    }
}

