/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.foundation.generation;

import com.kipti.bnb.foundation.client.ShipyardHelper;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.jetbrains.annotations.NotNull;

public class PonderLevelSource
extends ChunkGenerator {
    public static final MapCodec<PonderLevelSource> CODEC = RecordCodecBuilder.mapCodec(p_255576_ -> p_255576_.group((App)RegistryOps.retrieveElement((ResourceKey)Biomes.THE_VOID)).apply((Applicative)p_255576_, p_255576_.stable(PonderLevelSource::new)));

    public PonderLevelSource(Holder.Reference<Biome> biome) {
        super((BiomeSource)new FixedBiomeSource(biome));
    }

    public PonderLevelSource(BiomeSource biomeSource, Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter) {
        super(biomeSource, generationSettingsGetter);
    }

    @NotNull
    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void buildSurface(@NotNull WorldGenRegion level, @NotNull StructureManager structureManager, @NotNull RandomState random, @NotNull ChunkAccess chunk) {
    }

    public void applyBiomeDecoration(@NotNull WorldGenLevel level, @NotNull ChunkAccess chunk, @NotNull StructureManager structureManager) {
    }

    @NotNull
    public CompletableFuture<ChunkAccess> fillFromNoise(@NotNull Blender blender, @NotNull RandomState randomState, @NotNull StructureManager structureManager, @NotNull ChunkAccess chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        if (ShipyardHelper.isProbablyInShipyard(chunk.getPos().getWorldPosition())) {
            return CompletableFuture.completedFuture(chunk);
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = -64; y < -48; ++y) {
                    BlockState blockState = PonderLevelSource.getBlockStateFor(x, y, z);
                    pos.set(chunk.getPos().getBlockX(x), y, chunk.getPos().getBlockX(z));
                    chunk.setBlockState((BlockPos)pos, blockState, false);
                }
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    public int getBaseHeight(int x, int z, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull Heightmap.Types type, @NotNull LevelHeightAccessor level, @NotNull RandomState random) {
        return level.getMinBuildHeight() + 16;
    }

    @NotNull
    public NoiseColumn getBaseColumn(int x, int z, @NotNull LevelHeightAccessor height, @NotNull RandomState random) {
        return new NoiseColumn(height.getMinBuildHeight(), new BlockState[0]);
    }

    public void addDebugScreenInfo(@NotNull List<String> info, @NotNull RandomState random, @NotNull BlockPos pos) {
    }

    public static BlockState getBlockStateFor(int chunkX, int chunkY, int chunkZ) {
        return (chunkX + chunkY + chunkZ) % 2 == 0 ? Blocks.SNOW_BLOCK.defaultBlockState() : Blocks.WHITE_CONCRETE.defaultBlockState();
    }

    public void applyCarvers(@NotNull WorldGenRegion level, long seed, @NotNull RandomState random, @NotNull BiomeManager biomeManager, @NotNull StructureManager structureManager, @NotNull ChunkAccess chunk, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull GenerationStep.Carving step) {
    }

    public void spawnOriginalMobs(@NotNull WorldGenRegion level) {
    }

    public int getMinY() {
        return 0;
    }

    public int getGenDepth() {
        return 384;
    }

    public int getSeaLevel() {
        return -63;
    }
}

