/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.registry;

import com.kipti.bnb.CreateBitsnBobs;
import com.kipti.bnb.registry.BnbBlocks;
import com.kipti.bnb.registry.BnbFeatureFlag;
import com.kipti.bnb.registry.BnbItems;
import com.kipti.bnb.registry.BnbPaletteStoneTypes;
import com.simibubi.create.AllCreativeModeTabs;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.RegistryEntry;
import java.util.function.Supplier;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.ApiStatus;

public class BnbCreativeTabs {
    private static final DeferredRegister<CreativeModeTab> REGISTER = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"bits_n_bobs");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> BASE_CREATIVE_TAB = REGISTER.register("bnb_based", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"tab.bits_n_bobs.base")).withTabsBefore(new ResourceLocation[]{AllCreativeModeTabs.PALETTES_CREATIVE_TAB.getId()}).icon(() -> BnbItems.ICON_LIGHTBULB.asStack()).displayItems((p, o) -> BnbCreativeTabs.buildCreativeTabContents(p, o, () -> BASE_CREATIVE_TAB)).build());
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> DECO_CREATIVE_TAB = REGISTER.register("bnb_deco", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"tab.bits_n_bobs.deco")).withTabsBefore(new ResourceLocation[]{BASE_CREATIVE_TAB.getId()}).icon(() -> ((BlockEntry)BnbPaletteStoneTypes.ASURINE.getVariants().registeredBlocks.getFirst()).asStack()).displayItems((p, o) -> BnbCreativeTabs.buildCreativeTabContents(p, o, () -> DECO_CREATIVE_TAB)).build());

    private static boolean matchesBlockFilter(BlockItem item) {
        return !BnbBlocks.CHAIRS.contains(item.getBlock()) || BnbBlocks.CHAIRS.get(DyeColor.RED).is((Object)item.getBlock());
    }

    private static boolean matchesSearchOnlyBlockFilter(BlockItem item) {
        return BnbBlocks.CHAIRS.contains(item.getBlock()) && !BnbBlocks.CHAIRS.get(DyeColor.RED).is((Object)item.getBlock());
    }

    @ApiStatus.Internal
    public static void register(IEventBus modEventBus) {
        REGISTER.register(modEventBus);
    }

    private static void buildCreativeTabContents(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output, Supplier<DeferredHolder<CreativeModeTab, CreativeModeTab>> tabToGet) {
        for (RegistryEntry item : CreateBitsnBobs.REGISTRATE.getAll(Registries.ITEM)) {
            BlockItem blockItem;
            Object object;
            if (!CreateRegistrate.isInCreativeTab((RegistryEntry)item, tabToGet.get()) || !((object = item.get()) instanceof BlockItem) || !BnbFeatureFlag.isEnabled(blockItem = (BlockItem)object)) continue;
            if (BnbCreativeTabs.matchesSearchOnlyBlockFilter(blockItem)) {
                output.accept((ItemLike)item.get(), CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
                continue;
            }
            if (!BnbCreativeTabs.matchesBlockFilter(blockItem)) continue;
            output.accept((ItemLike)item.get());
        }
        for (RegistryEntry item : CreateBitsnBobs.REGISTRATE.getAll(Registries.ITEM)) {
            if (!CreateRegistrate.isInCreativeTab((RegistryEntry)item, tabToGet.get()) || item.get() instanceof BlockItem || !BnbCreativeTabs.matchesItemFilter((Item)item.get())) continue;
            output.accept((ItemLike)item.get());
        }
    }

    private static boolean matchesItemFilter(Item item) {
        return !BnbItems.ICON_LIGHTBULB.is(item);
    }
}

