/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;

public class BubbleModel<T extends Player>
extends EntityModel<T> {
    public final ModelPart bubble;

    public BubbleModel(ModelPart root) {
        this.bubble = root.getChild("bubble");
    }

    public static LayerDefinition createLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("bubble", CubeListBuilder.create().texOffs(0, 0).addBox(-5.5f, -9.0f, -5.5f, 11.0f, 11.0f, 11.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float wobbleH = Mth.cos((float)(ageInTicks / 4.0f)) * 0.2f;
        float wobbleV = Mth.sin((float)(ageInTicks / 4.0f)) * 0.1f;
        this.bubble.xScale += wobbleH;
        this.bubble.yScale += wobbleV;
        this.bubble.zScale += wobbleV;
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int color) {
        this.bubble.render(poseStack, vertexConsumer, packedLight, packedOverlay, color);
    }
}

