/*
 * Decompiled with CFR 0.152.
 */
package io.github.fishstiz.minecraftcursor.gui.screen.panel;

import io.github.fishstiz.minecraftcursor.CursorResourceLoader;
import io.github.fishstiz.minecraftcursor.cursor.Cursor;
import io.github.fishstiz.minecraftcursor.gui.screen.CatalogBrowserScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractOptionsPanel
extends CatalogBrowserScreen.ContentPanel {
    protected static final Component ENABLE_TEXT = Component.translatable((String)"minecraft-cursor.options.enabled");
    protected static final Component SCALE_TEXT = Component.translatable((String)"minecraft-cursor.options.scale");
    protected static final Component GUI_SCALE_TEXT = Component.translatable((String)"minecraft-cursor.options.scale.gui");
    protected static final Component XHOT_TEXT = Component.translatable((String)"minecraft-cursor.options.xhot");
    protected static final Component YHOT_TEXT = Component.translatable((String)"minecraft-cursor.options.yhot");
    protected static final Component HOTSPOT_SUFFIX = Component.translatable((String)"minecraft-cursor.options.hotspot-suffix");
    private final Component title;
    private StringWidget titleWidget;

    protected AbstractOptionsPanel(Component title) {
        this.title = AbstractOptionsPanel.withBold(title);
    }

    protected abstract void initContents();

    protected abstract void repositionContents(int var1, int var2);

    @Override
    protected final void init() {
        this.titleWidget = new StringWidget(this.title, this.getFont()).alignLeft();
        this.addRenderableIndexedWidget((AbstractWidget)this.titleWidget);
        this.initContents();
    }

    @Override
    protected final void repositionElements() {
        this.titleWidget.setSize(this.getHeaderWidth(), this.getHeaderHeight());
        this.titleWidget.setPosition(this.getX(), this.getY());
        this.repositionContents(this.getX(), this.getY() + this.titleWidget.getHeight() + this.getSpacing());
    }

    protected int computeMaxHeight(int top) {
        return Math.max(0, this.getHeight() - (top - this.getY()));
    }

    protected boolean loadCursor(@NotNull Cursor deferredCursor) {
        if (deferredCursor.isLoaded()) {
            throw new IllegalStateException("Cursor is already loaded");
        }
        if (CursorResourceLoader.loadCursorTexture(this.getMinecraft().getResourceManager(), deferredCursor)) {
            return true;
        }
        this.getMinecraft().getToasts().addToast((Toast)SystemToast.multiline((Minecraft)this.getMinecraft(), (SystemToast.SystemToastId)SystemToast.SystemToastId.PACK_LOAD_FAILURE, (Component)Component.translatable((String)"resourcePack.load_fail"), (Component)Component.translatable((String)"minecraft-cursor.options.global.deferred_loading.fail", (Object[])new Object[]{deferredCursor.getText()})));
        return false;
    }

    protected void refreshWidgets() {
        this.clearWidgets();
        this.init();
    }

    @Override
    protected void added() {
        this.refreshWidgets();
    }

    private static MutableComponent withBold(Component text) {
        return text.copy().withStyle(style -> style.withBold(Boolean.valueOf(true)));
    }
}

