/*
 * Decompiled with CFR 0.152.
 */
package shadow.hypherionmc.mcdiscordformatter.renderer.implementation;

import java.util.function.Function;
import shadow.hypherionmc.mcdiscordformatter.minecraft.MinecraftSerializerOptions;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.TextStyle;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.Node;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.StyleNode;
import shadow.hypherionmc.mcdiscordformatter.reloc.dev.vankka.simpleast.core.node.TextNode;
import shadow.hypherionmc.mcdiscordformatter.renderer.NodeRenderer;

public class DefaultDiscordEscapingRenderer
implements NodeRenderer<String> {
    public static final DefaultDiscordEscapingRenderer INSTANCE = new DefaultDiscordEscapingRenderer();

    private String render(String renderTo, Node<Object> node, boolean after) {
        if (node instanceof TextNode && !after) {
            return renderTo + ((TextNode)node).getContent();
        }
        if (node instanceof StyleNode) {
            StringBuilder output = new StringBuilder(renderTo);
            for (Object style : ((StyleNode)node).getStyles()) {
                TextStyle textStyle = (TextStyle)style;
                TextStyle.Type styleType = textStyle.getType();
                if (styleType == TextStyle.Type.QUOTE && after) continue;
                output.append(this.getChar(textStyle));
            }
            return output.toString();
        }
        return null;
    }

    private String getChar(TextStyle textStyle) {
        switch (textStyle.getType()) {
            case BOLD: {
                return "\\*\\*";
            }
            case QUOTE: {
                return "\\>";
            }
            case ITALICS: {
                return "\\" + (textStyle.getExtra().getOrDefault("asterisk", "true").equals("true") ? "*" : "_");
            }
            case SPOILER: {
                return "\\|\\|";
            }
            case UNDERLINE: {
                return "\\_\\_";
            }
            case CODE_BLOCK: {
                return "\\`\\`\\`";
            }
            case CODE_STRING: {
                return "\\`";
            }
        }
        return null;
    }

    @Override
    public String render(String renderTo, Node<Object> node, MinecraftSerializerOptions<String> serializerOptions, Function<Node<Object>, String> renderWithChildren) {
        return this.render(renderTo, node, false);
    }

    @Override
    public String renderAfterChildren(String renderTo, Node<Object> node, MinecraftSerializerOptions<String> serializerOptions, Function<Node<Object>, String> renderWithChildren) {
        return this.render(renderTo, node, true);
    }
}

